/*
 * Decompiled with CFR 0.152.
 */
package com.github.squirrelgrip.scientist4k.controlled.http.server;

import com.github.squirrelgrip.scientist4k.controlled.http.server.ControlledHttpExperiment;
import com.github.squirrelgrip.scientist4k.core.AbstractExperiment;
import com.github.squirrelgrip.scientist4k.core.configuration.ExperimentConfiguration;
import com.github.squirrelgrip.scientist4k.core.exception.LaboratoryException;
import com.github.squirrelgrip.scientist4k.core.model.ExperimentOption;
import com.github.squirrelgrip.scientist4k.http.core.configuration.EndPointConfiguration;
import com.github.squirrelgrip.scientist4k.http.core.configuration.HttpExperimentConfiguration;
import com.github.squirrelgrip.scientist4k.http.core.configuration.MappingConfiguration;
import com.github.squirrelgrip.scientist4k.metrics.Metrics;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0007J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0007J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u001f\u0010 \u001a\u00020\u00002\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\"\"\u00020\r\u00a2\u0006\u0002\u0010#J\u001f\u0010$\u001a\u00020\u00002\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\"\"\u00020\u0010\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0007J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0014J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/github/squirrelgrip/scientist4k/controlled/http/server/ControlledHttpExperimentBuilder;", "", "httpExperimentConfiguration", "Lcom/github/squirrelgrip/scientist4k/http/core/configuration/HttpExperimentConfiguration;", "(Lcom/github/squirrelgrip/scientist4k/http/core/configuration/HttpExperimentConfiguration;)V", "()V", "candidateConfig", "Lcom/github/squirrelgrip/scientist4k/http/core/configuration/EndPointConfiguration;", "controlConfig", "eventBus", "Lcom/google/common/eventbus/EventBus;", "experimentOptions", "Ljava/util/EnumSet;", "Lcom/github/squirrelgrip/scientist4k/core/model/ExperimentOption;", "mappings", "", "Lcom/github/squirrelgrip/scientist4k/http/core/configuration/MappingConfiguration;", "metrics", "Lcom/github/squirrelgrip/scientist4k/metrics/Metrics;", "name", "", "referenceConfig", "samplePrefix", "sampleThreshold", "", "build", "Lcom/github/squirrelgrip/scientist4k/controlled/http/server/ControlledHttpExperiment;", "withCandidateConfig", "candidateConfiguration", "withControlConfig", "controlConfiguration", "withEventBus", "withExperimentOptions", "experimentOption", "", "([Lcom/github/squirrelgrip/scientist4k/core/model/ExperimentOption;)Lcom/github/squirrelgrip/scientist4k/controlled/http/server/ControlledHttpExperimentBuilder;", "withMappings", "mapping", "([Lcom/github/squirrelgrip/scientist4k/http/core/configuration/MappingConfiguration;)Lcom/github/squirrelgrip/scientist4k/controlled/http/server/ControlledHttpExperimentBuilder;", "withMetrics", "withName", "withReferenceConfig", "referenceConfiguration", "withSamplePrefix", "withSampleThreshold", "scientist4k-controlled-http-server"})
public final class ControlledHttpExperimentBuilder {
    private int sampleThreshold;
    private List<MappingConfiguration> mappings;
    private String name;
    private Metrics metrics;
    private String samplePrefix;
    private EventBus eventBus;
    private EnumSet<ExperimentOption> experimentOptions;
    private EndPointConfiguration controlConfig;
    private EndPointConfiguration candidateConfig;
    private EndPointConfiguration referenceConfig;

    @NotNull
    public final ControlledHttpExperimentBuilder withName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withMetrics(@NotNull Metrics metrics) {
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        this.metrics = metrics;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withSamplePrefix(@NotNull String samplePrefix) {
        Intrinsics.checkNotNullParameter((Object)samplePrefix, (String)"samplePrefix");
        this.samplePrefix = samplePrefix;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withControlConfig(@NotNull EndPointConfiguration controlConfiguration) {
        Intrinsics.checkNotNullParameter((Object)controlConfiguration, (String)"controlConfiguration");
        this.controlConfig = controlConfiguration;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withCandidateConfig(@NotNull EndPointConfiguration candidateConfiguration) {
        Intrinsics.checkNotNullParameter((Object)candidateConfiguration, (String)"candidateConfiguration");
        this.candidateConfig = candidateConfiguration;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withReferenceConfig(@NotNull EndPointConfiguration referenceConfiguration) {
        Intrinsics.checkNotNullParameter((Object)referenceConfiguration, (String)"referenceConfiguration");
        this.referenceConfig = referenceConfiguration;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withEventBus(@NotNull EventBus eventBus) {
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.eventBus = eventBus;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withExperimentOptions(ExperimentOption ... experimentOption) {
        Intrinsics.checkNotNullParameter((Object)experimentOption, (String)"experimentOption");
        EnumSet enumSet = EnumSet.copyOf((Collection)ArraysKt.toList((Object[])experimentOption));
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"EnumSet.copyOf(experimentOption.toList())");
        this.experimentOptions = enumSet;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withMappings(MappingConfiguration ... mapping) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        this.mappings = ArraysKt.toList((Object[])mapping);
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withSampleThreshold(int sampleThreshold) {
        this.sampleThreshold = sampleThreshold;
        return this;
    }

    @NotNull
    public final ControlledHttpExperiment build() {
        if (this.controlConfig != null && this.referenceConfig != null && this.candidateConfig != null) {
            ExperimentConfiguration experimentConfiguration = new ExperimentConfiguration(this.name, this.metrics, this.samplePrefix, this.experimentOptions, this.sampleThreshold);
            EndPointConfiguration endPointConfiguration = this.controlConfig;
            Intrinsics.checkNotNull((Object)endPointConfiguration);
            EndPointConfiguration endPointConfiguration2 = this.referenceConfig;
            Intrinsics.checkNotNull((Object)endPointConfiguration2);
            EndPointConfiguration endPointConfiguration3 = this.candidateConfig;
            Intrinsics.checkNotNull((Object)endPointConfiguration3);
            return new ControlledHttpExperiment(experimentConfiguration, this.eventBus, this.mappings, endPointConfiguration, endPointConfiguration2, endPointConfiguration3);
        }
        throw (Throwable)new LaboratoryException("primaryControl, secondaryControl and candidate configurations must be set");
    }

    public ControlledHttpExperimentBuilder() {
        this.sampleThreshold = 100;
        this.mappings = CollectionsKt.emptyList();
        this.name = "Test";
        this.metrics = Metrics.DROPWIZARD;
        this.samplePrefix = "";
        this.eventBus = AbstractExperiment.Companion.getDEFAULT_EVENT_BUS();
        this.experimentOptions = ExperimentOption.Companion.getDEFAULT();
    }

    /*
     * WARNING - void declaration
     */
    public ControlledHttpExperimentBuilder(@NotNull HttpExperimentConfiguration httpExperimentConfiguration) {
        Collection<MappingConfiguration> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)httpExperimentConfiguration, (String)"httpExperimentConfiguration");
        this();
        this.name = httpExperimentConfiguration.getExperiment().getName();
        this.metrics = httpExperimentConfiguration.getExperiment().getMetrics();
        this.samplePrefix = httpExperimentConfiguration.getExperiment().getSamplePrefix();
        this.experimentOptions = httpExperimentConfiguration.getExperiment().getExperimentOptions();
        this.controlConfig = httpExperimentConfiguration.getControl();
        this.candidateConfig = httpExperimentConfiguration.getCandidate();
        this.referenceConfig = httpExperimentConfiguration.getReference();
        Iterable iterable = httpExperimentConfiguration.getMappings();
        ControlledHttpExperimentBuilder controlledHttpExperimentBuilder = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void control;
            void $dstr$control$candidate;
            MappingConfiguration mappingConfiguration = (MappingConfiguration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = $dstr$control$candidate.component1();
            String candidate = $dstr$control$candidate.component2();
            MappingConfiguration mappingConfiguration2 = new MappingConfiguration((String)control, candidate, null, 4, null);
            collection.add(mappingConfiguration2);
        }
        collection = (List)destination$iv$iv;
        controlledHttpExperimentBuilder.mappings = collection;
    }
}

