/*
 * Decompiled with CFR 0.152.
 */
package com.github.squirrelgrip.scientist4k.http.core.comparator;

import com.github.squirrelgrip.scientist4k.core.comparator.ExperimentComparator;
import com.github.squirrelgrip.scientist4k.core.model.ComparisonResult;
import com.github.squirrelgrip.scientist4k.http.core.comparator.ContentComparatorKt;
import com.github.squirrelgrip.scientist4k.http.core.comparator.ContentTypeComparator;
import com.github.squirrelgrip.scientist4k.http.core.comparator.DefaultContentTypeComparator;
import com.github.squirrelgrip.scientist4k.http.core.comparator.JsonContentTypeComparator;
import com.github.squirrelgrip.scientist4k.http.core.comparator.StatusComparator;
import com.github.squirrelgrip.scientist4k.http.core.model.HttpExperimentResponse;
import com.google.common.net.MediaType;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0019\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0096\u0002\u00a8\u0006\r"}, d2={"Lcom/github/squirrelgrip/scientist4k/http/core/comparator/ContentComparator;", "Lcom/github/squirrelgrip/scientist4k/core/comparator/ExperimentComparator;", "Lcom/github/squirrelgrip/scientist4k/http/core/model/HttpExperimentResponse;", "()V", "getContentComparator", "Lcom/github/squirrelgrip/scientist4k/http/core/comparator/ContentTypeComparator;", "mediaType", "Lcom/google/common/net/MediaType;", "invoke", "Lcom/github/squirrelgrip/scientist4k/core/model/ComparisonResult;", "control", "candidate", "Companion", "scientist4k-http-core"})
public final class ContentComparator
implements ExperimentComparator<HttpExperimentResponse> {
    private static final Logger LOGGER;
    private static final ContentTypeComparator defaultContentTypeComparator;
    private static final Map<MediaType, ContentTypeComparator> contentComparators;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public ComparisonResult invoke(@NotNull HttpExperimentResponse control, @NotNull HttpExperimentResponse candidate) {
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        LOGGER.trace("Comparing Contents...");
        MediaType controlContentType = ContentComparatorKt.access$toMediaType(control.contentType());
        MediaType candidateContentType = ContentComparatorKt.access$toMediaType(candidate.contentType());
        if (controlContentType != null) {
            MediaType mediaType = candidateContentType;
            if (Intrinsics.areEqual((Object)controlContentType.withoutParameters(), (Object)(mediaType != null ? mediaType.withoutParameters() : null))) {
                String controlContent = control.getContents();
                String candidateContent = candidate.getContents();
                return (ComparisonResult)this.getContentComparator(controlContentType).invoke(controlContent, candidateContent);
            }
        }
        return new ComparisonResult(new String[]{"Content-Type is different: " + controlContentType + " != " + candidateContentType + '.'});
    }

    private final ContentTypeComparator getContentComparator(MediaType mediaType) {
        Map<MediaType, ContentTypeComparator> $this$filterKeys$iv = contentComparators;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<MediaType, ContentTypeComparator> result$iv = new LinkedHashMap<MediaType, ContentTypeComparator>();
        Map<MediaType, ContentTypeComparator> map = $this$filterKeys$iv;
        boolean bl = false;
        for (Map.Entry<MediaType, ContentTypeComparator> entry$iv : map.entrySet()) {
            MediaType it = entry$iv.getKey();
            boolean bl2 = false;
            if (!mediaType.withoutParameters().is(it.withoutParameters())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        ContentTypeComparator contentTypeComparator = (ContentTypeComparator)CollectionsKt.firstOrNull((Iterable)((Map)result$iv).values());
        if (contentTypeComparator == null) {
            contentTypeComparator = defaultContentTypeComparator;
        }
        return contentTypeComparator;
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(StatusComparator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026usComparator::class.java)");
        LOGGER = logger;
        defaultContentTypeComparator = new DefaultContentTypeComparator();
        contentComparators = MapsKt.mapOf((Pair)TuplesKt.to((Object)MediaType.JSON_UTF_8, (Object)new JsonContentTypeComparator()));
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/github/squirrelgrip/scientist4k/http/core/comparator/ContentComparator$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "contentComparators", "", "Lcom/google/common/net/MediaType;", "Lcom/github/squirrelgrip/scientist4k/http/core/comparator/ContentTypeComparator;", "defaultContentTypeComparator", "scientist4k-http-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

