/*
 * Decompiled with CFR 0.152.
 */
package com.github.squirrelgrip.scientist4k.http.core.consumer;

import com.github.squirrelgrip.extension.json.JsonExtensionsKt;
import com.github.squirrelgrip.scientist4k.http.core.consumer.Consumer;
import com.google.common.eventbus.Subscribe;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/github/squirrelgrip/scientist4k/http/core/consumer/ElasticSearchConsumer;", "Lcom/github/squirrelgrip/scientist4k/http/core/consumer/Consumer;", "", "url", "", "(Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "receiveResult", "", "experimentResult", "Companion", "scientist4k-http-core"})
public final class ElasticSearchConsumer
implements Consumer<Object> {
    @NotNull
    private final String url;
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    public static final Companion Companion;

    @Override
    @Subscribe
    public void receiveResult(@NotNull Object experimentResult) {
        Intrinsics.checkNotNullParameter((Object)experimentResult, (String)"experimentResult");
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String json = JsonExtensionsKt.toJson((Object)experimentResult);
        RequestBuilder requestBuilder = RequestBuilder.create((String)"POST");
        boolean bl = false;
        int n = 0;
        RequestBuilder $this$apply = requestBuilder;
        boolean bl2 = false;
        $this$apply.setUri(this.url);
        $this$apply.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        HttpUriRequest request = requestBuilder.build();
        CloseableHttpResponse response = httpClient.execute(request);
        if (LOGGER.isInfoEnabled()) {
            int statusCode;
            CloseableHttpResponse closeableHttpResponse = response;
            Intrinsics.checkNotNullExpressionValue((Object)closeableHttpResponse, (String)"response");
            StatusLine statusLine = closeableHttpResponse.getStatusLine();
            Intrinsics.checkNotNullExpressionValue((Object)statusLine, (String)"response.statusLine");
            n = statusCode = statusLine.getStatusCode();
            if (200 <= n && 299 >= n) {
                LOGGER.info("Successfully published experimentResult");
            } else {
                LOGGER.info("Publishing result failed with status " + statusCode);
            }
        }
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public ElasticSearchConsumer(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(ElasticSearchConsumer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026archConsumer::class.java)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/squirrelgrip/scientist4k/http/core/consumer/ElasticSearchConsumer$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "scientist4k-http-core"})
    public static final class Companion {
        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

