/*
 * Decompiled with CFR 0.152.
 */
package com.github.squirrelgrip.scientist4k.http.core.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.squirrelgrip.scientist4k.http.core.extension.MediaTypeExtensionKt;
import com.google.common.net.MediaType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB-\u0012\b\b\u0001\u0010\u0002\u001a\u00020\n\u0012\u0014\b\u0001\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001f\u001a\u00020\nH\u00c6\u0003J\u0015\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003J\t\u0010!\u001a\u00020\u000eH\u00c6\u0003J3\u0010\"\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\n2\u0014\b\u0003\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010&\u001a\u00020\nH\u0016J\t\u0010'\u001a\u00020\fH\u00d6\u0001R\u0016\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u0004\u0018\u00010\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a8G\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006("}, d2={"Lcom/github/squirrelgrip/scientist4k/http/core/model/ExperimentResponse;", "", "status", "Lorg/apache/http/StatusLine;", "headers", "", "Lorg/apache/http/Header;", "entity", "Lorg/apache/http/HttpEntity;", "(Lorg/apache/http/StatusLine;[Lorg/apache/http/Header;Lorg/apache/http/HttpEntity;)V", "", "", "", "body", "", "(ILjava/util/Map;[B)V", "getBody", "()[B", "contentType", "getContentType", "()Ljava/lang/String;", "contents", "getContents", "getHeaders", "()Ljava/util/Map;", "mediaType", "Lcom/google/common/net/MediaType;", "getMediaType", "()Lcom/google/common/net/MediaType;", "getStatus", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "scientist4k-http-core"})
public final class ExperimentResponse {
    @JsonProperty(value="contentType")
    @Nullable
    private final String contentType;
    @JsonProperty(value="contents")
    @NotNull
    private final String contents;
    private final int status;
    @NotNull
    private final Map<String, String> headers;
    @JsonIgnore
    @NotNull
    private final byte[] body;

    @JsonIgnore
    @Nullable
    public final MediaType getMediaType() {
        return this.contentType != null ? MediaType.parse((String)this.contentType) : null;
    }

    @Nullable
    public final String getContentType() {
        return this.contentType;
    }

    @NotNull
    public final String getContents() {
        return this.contents;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.github.squirrelgrip.scientist4k.http.core.model.ExperimentResponse");
        }
        ExperimentResponse cfr_ignored_0 = (ExperimentResponse)object2;
        if (this.status != ((ExperimentResponse)other).status) {
            return false;
        }
        if (Intrinsics.areEqual(this.headers, ((ExperimentResponse)other).headers) ^ true) {
            return false;
        }
        byte[] byArray = this.body;
        byte[] byArray2 = ((ExperimentResponse)other).body;
        boolean bl = false;
        return Arrays.equals(byArray, byArray2);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.status);
        result = 31 * result + ((Object)this.headers).hashCode();
        byte[] byArray = this.body;
        boolean bl = false;
        result = 31 * result + Arrays.hashCode(byArray);
        return result;
    }

    public final int getStatus() {
        return this.status;
    }

    @NotNull
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final byte[] getBody() {
        return this.body;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ExperimentResponse(@JsonProperty(value="status") int status, @JsonProperty(value="headers") @NotNull Map<String, String> headers, @NotNull byte[] body) {
        String string;
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.status = status;
        this.headers = headers;
        this.body = body;
        this.contentType = this.headers.get("Content-Type");
        MediaType mediaType = this.getMediaType();
        if (mediaType != null && MediaTypeExtensionKt.isTextLike(mediaType)) {
            byte[] byArray = this.body;
            boolean bl = false;
            string = new String(byArray, Charsets.UTF_8);
        } else {
            String string2 = Base64.getEncoder().encodeToString(this.body);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEncoder().encodeToString(body)");
        }
        this.contents = string;
    }

    /*
     * WARNING - void declaration
     */
    public ExperimentResponse(@NotNull StatusLine status, @NotNull Header[] headers, @NotNull HttpEntity entity) {
        Object object;
        Map map;
        ExperimentResponse experimentResponse2;
        int n;
        block4: {
            block3: {
                Collection<Pair> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                Header[] headerArray = headers;
                n = status.getStatusCode();
                experimentResponse2 = this;
                boolean $i$f$map = false;
                void var6_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                void var9_11 = $this$mapTo$iv$iv;
                int n2 = ((void)var9_11).length;
                for (int i = 0; i < n2; ++i) {
                    void it;
                    void item$iv$iv;
                    void var13_15 = item$iv$iv = var9_11[i];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getValue());
                    collection.add(pair);
                }
                collection = (List)destination$iv$iv;
                map = MapsKt.toMap((Iterable)collection);
                object = entity.getContent();
                if (object == null) break block3;
                byte[] byArray = ByteStreamsKt.readBytes((InputStream)object);
                object = byArray;
                if (byArray != null) break block4;
            }
            object = new byte[0];
        }
        experimentResponse2(n, map, (byte[])object);
    }

    public final int component1() {
        return this.status;
    }

    @NotNull
    public final Map<String, String> component2() {
        return this.headers;
    }

    @NotNull
    public final byte[] component3() {
        return this.body;
    }

    @NotNull
    public final ExperimentResponse copy(@JsonProperty(value="status") int status, @JsonProperty(value="headers") @NotNull Map<String, String> headers, @NotNull byte[] body) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return new ExperimentResponse(status, headers, body);
    }

    public static /* synthetic */ ExperimentResponse copy$default(ExperimentResponse experimentResponse2, int n, Map map, byte[] byArray, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = experimentResponse2.status;
        }
        if ((n2 & 2) != 0) {
            map = experimentResponse2.headers;
        }
        if ((n2 & 4) != 0) {
            byArray = experimentResponse2.body;
        }
        return experimentResponse2.copy(n, map, byArray);
    }

    @NotNull
    public String toString() {
        return "ExperimentResponse(status=" + this.status + ", headers=" + this.headers + ", body=" + Arrays.toString(this.body) + ")";
    }
}

