/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.adaptation;

import com.econage.core.db.mybatis.MybatisException;
import com.econage.core.db.mybatis.adaptation.MybatisGlobalAssistant;
import com.econage.core.db.mybatis.adaptation.MybatisMapperRegistry;
import com.econage.core.db.mybatis.mapper.dyna.adaptation.DynaBeanResultSetHandler;
import com.econage.core.db.mybatis.mapper.dyna.entity.DynaBean;
import com.econage.core.db.mybatis.mapper.dyna.entity.DynaClass;
import java.util.Map;
import org.apache.ibatis.binding.MapperRegistry;
import org.apache.ibatis.executor.BatchExecutor;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ReuseExecutor;
import org.apache.ibatis.executor.SimpleExecutor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.transaction.Transaction;

public class MybatisConfiguration
extends Configuration {
    private static final Log logger = LogFactory.getLog(MybatisConfiguration.class);
    public final MybatisMapperRegistry mybatisMapperRegistry = new MybatisMapperRegistry(this);
    private MybatisGlobalAssistant globalAssistant;
    private Class<DynaBean> dynaBeanClass = DynaBean.class;

    public MybatisConfiguration() {
        if (logger.isDebugEnabled()) {
            logger.debug("Mybatis init success.");
        }
    }

    public void addMappedStatement(MappedStatement ms) {
        if (logger.isDebugEnabled()) {
            logger.debug("addMappedStatement: " + ms.getId());
        }
        if (this.mappedStatements.containsKey(ms.getId())) {
            logger.error("mapper[" + ms.getId() + "] is ignored, because it's exists, maybe from xml file");
            return;
        }
        super.addMappedStatement(ms);
    }

    public MapperRegistry getMapperRegistry() {
        return this.mybatisMapperRegistry;
    }

    public <T> void addMapper(Class<T> type) {
        this.mybatisMapperRegistry.addMapper(type);
    }

    public void addMappers(String packageName, Class<?> superType) {
        this.mybatisMapperRegistry.addMappers(packageName, superType);
    }

    public void addMappers(String packageName) {
        this.mybatisMapperRegistry.addMappers(packageName);
    }

    public <T> T getMapper(Class<T> type, SqlSession sqlSession) {
        return this.mybatisMapperRegistry.getMapper(type, sqlSession);
    }

    public boolean hasMapper(Class<?> type) {
        return this.mybatisMapperRegistry.hasMapper(type);
    }

    public MybatisGlobalAssistant getGlobalAssistant() {
        return this.globalAssistant;
    }

    public void setGlobalAssistant(MybatisGlobalAssistant globalAssistant) {
        this.globalAssistant = globalAssistant;
    }

    public Executor newExecutor(Transaction transaction, ExecutorType executorType) {
        executorType = executorType == null ? this.defaultExecutorType : executorType;
        ExecutorType executorType2 = executorType = executorType == null ? ExecutorType.SIMPLE : executorType;
        Object executor = ExecutorType.BATCH == executorType ? new BatchExecutor((Configuration)this, transaction) : (ExecutorType.REUSE == executorType ? new ReuseExecutor((Configuration)this, transaction) : new SimpleExecutor((Configuration)this, transaction));
        executor = (Executor)this.interceptorChain.pluginAll(executor);
        return executor;
    }

    private boolean isDynaBeanResult(MappedStatement mappedStatement) {
        for (ResultMap resultMap : mappedStatement.getResultMaps()) {
            if (!this.dynaBeanClass.isAssignableFrom(resultMap.getType())) continue;
            return true;
        }
        return false;
    }

    private DynaClass detectDynaCls(ParameterHandler parameterHandler) {
        Object parameter = parameterHandler.getParameterObject();
        if (parameter instanceof Map) {
            Map params = (Map)parameter;
            Object dynaCls = params.get("dynaCls");
            if (!(dynaCls instanceof DynaClass)) {
                throw new MybatisException("Unexpected error,dynaCls error type:[" + dynaCls.getClass().getName() + "]");
            }
            return (DynaClass)dynaCls;
        }
        throw new MybatisException("Unexpected error,parameter error type:[" + parameter.getClass().getName() + "]");
    }

    public ResultSetHandler newResultSetHandler(Executor executor, MappedStatement mappedStatement, RowBounds rowBounds, ParameterHandler parameterHandler, ResultHandler resultHandler, BoundSql boundSql) {
        if (this.isDynaBeanResult(mappedStatement)) {
            DynaBeanResultSetHandler resultSetHandler = new DynaBeanResultSetHandler(executor, mappedStatement, parameterHandler, resultHandler, boundSql, rowBounds, this.detectDynaCls(parameterHandler));
            resultSetHandler = (ResultSetHandler)this.interceptorChain.pluginAll((Object)resultSetHandler);
            return resultSetHandler;
        }
        return super.newResultSetHandler(executor, mappedStatement, rowBounds, parameterHandler, resultHandler, boundSql);
    }
}

