/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.adaptation;

import com.econage.core.db.mybatis.adaptation.MybatisConfiguration;
import com.econage.core.db.mybatis.entity.MybatisTableInfoHelper;
import com.econage.core.db.mybatis.entity.TableInfo;
import com.econage.core.db.mybatis.enums.DBType;
import com.econage.core.db.mybatis.enums.FieldStrategy;
import com.econage.core.db.mybatis.enums.IdType;
import com.econage.core.db.mybatis.mapper.BaseMapper;
import com.econage.core.db.mybatis.mapper.base.SqlInjector;
import com.econage.core.db.mybatis.uid.dbincrementer.IKeyGenerator;
import com.econage.core.db.mybatis.util.MybatisClassUtils;
import com.econage.core.db.mybatis.util.MybatisJdbcUtils;
import com.econage.core.db.mybatis.util.MybatisStringUtils;
import com.econage.core.db.mybatis.wherelogic.MybatisWhereLogicHelper;
import com.econage.core.db.mybatis.wherelogic.WhereLogicInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.reflect.Reflection;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class MybatisGlobalAssistant
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(MybatisGlobalAssistant.class);
    private final MybatisConfiguration configuration;
    private final SqlInjector sqlInjector;
    private DBType dbType;
    private IdType defaultIdType = IdType.ID_WORKER;
    private String dbColumnPrefix = "";
    private String dbColumnSuffix = "_";
    private boolean isCapitalMode = false;
    private IKeyGenerator keyGenerator;
    private FieldStrategy defaultFieldStrategy = FieldStrategy.NOT_NULL;
    private String identifierQuote;
    private Set<String> mapperRegistryCache = new ConcurrentSkipListSet<String>();
    private final ConcurrentHashMap<Class<?>, TableInfo> mapperTableInfoMap = new ConcurrentHashMap(5000);
    private final ConcurrentHashMap<Class<?>, TableInfo> modelTableInfoMap = new ConcurrentHashMap(5000);
    private final ConcurrentHashMap<Class<?>, WhereLogicInfo> whereLogicInfoMap = new ConcurrentHashMap(5000);
    private final Set<String> excludeWhereLogicType = new ConcurrentSkipListSet<String>();
    private boolean ignoreScanPackages;
    private String[] packageNames;
    private boolean globalCacheEnabled;
    private Set<String> disabledPropertyInDefaultUpdateMethod = Sets.newHashSet((Object[])new String[]{"createDate", "createUser"});

    public MybatisGlobalAssistant(MybatisConfiguration configuration) {
        this.configuration = configuration;
        this.sqlInjector = new SqlInjector(this);
    }

    public IKeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public void setKeyGenerator(IKeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public DBType getDbType() {
        return this.dbType;
    }

    public void setDbTypeOfJdbcUrl(String jdbcUrl) {
        this.dbType = MybatisJdbcUtils.getDbType(jdbcUrl);
    }

    public void setDbType(String dbType) {
        this.dbType = DBType.getDBType(dbType);
    }

    public void setDbType(DBType dbType) {
        this.dbType = dbType;
    }

    public IdType getDefaultIdType() {
        return this.defaultIdType;
    }

    public void setDefaultIdType(String defaultIdType) {
        this.defaultIdType = IdType.valueOf(defaultIdType);
    }

    public boolean isDbColumnUnderline() {
        return this.configuration.isMapUnderscoreToCamelCase();
    }

    public SqlInjector getSqlInjector() {
        return this.sqlInjector;
    }

    public FieldStrategy getDefaultFieldStrategy() {
        return this.defaultFieldStrategy;
    }

    public void setDefaultFieldStrategy(int defaultFieldStrategy) {
        this.defaultFieldStrategy = FieldStrategy.getFieldStrategy(defaultFieldStrategy);
    }

    public boolean isCapitalMode() {
        return this.isCapitalMode;
    }

    public void setCapitalMode(boolean isCapitalMode) {
        this.isCapitalMode = isCapitalMode;
    }

    public String getDbColumnPrefix() {
        return this.dbColumnPrefix;
    }

    public void setDbColumnPrefix(String dbColumnPrefix) {
        this.dbColumnPrefix = dbColumnPrefix;
    }

    public String getDbColumnSuffix() {
        return this.dbColumnSuffix;
    }

    public void setDbColumnSuffix(String dbColumnSuffix) {
        this.dbColumnSuffix = dbColumnSuffix;
    }

    public MybatisConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getIdentifierQuote() {
        if (null == this.identifierQuote) {
            return this.dbType.getQuote();
        }
        return this.identifierQuote;
    }

    public void setIdentifierQuote(String identifierQuote) {
        this.identifierQuote = identifierQuote;
    }

    public boolean isGlobalCacheEnabled() {
        return this.globalCacheEnabled;
    }

    public void setGlobalCacheEnabled(boolean globalCacheEnabled) {
        this.globalCacheEnabled = globalCacheEnabled;
    }

    public boolean isMapperParsed(Class<?> mapper) {
        if (!this.isMapperClass(mapper)) {
            throw new IllegalArgumentException("it's not a mapper class.");
        }
        return this.mapperRegistryCache.contains(mapper.getName());
    }

    public boolean isMapperClass(Class<?> resolvedCls) {
        Preconditions.checkNotNull(resolvedCls, (Object)"mapper is null!");
        if (resolvedCls.isInterface() && BaseMapper.class != resolvedCls) {
            if (BaseMapper.class.isAssignableFrom(resolvedCls)) {
                return true;
            }
            if (resolvedCls.getAnnotation(Mapper.class) != null) {
                return true;
            }
        }
        return false;
    }

    public void ignoreScanPackage() {
        this.ignoreScanPackages = true;
    }

    public void setScanPackages(Class<?> ... cls) {
        if (this.ignoreScanPackages) {
            return;
        }
        if (ArrayUtils.isEmpty((Object[])cls)) {
            throw new IllegalArgumentException("class is null or empty!");
        }
        String[] packageNames = new String[cls.length];
        int len = cls.length;
        for (int idx = 0; idx < len; ++idx) {
            packageNames[idx] = Reflection.getPackageName(cls[idx]);
        }
        this.packageNames = packageNames;
    }

    public void inspectInject4Mapper(MapperBuilderAssistant mapperBuilderAssistant, Class<?> mapper) {
        this.sqlInjector.inspectInject(mapperBuilderAssistant, mapper);
    }

    public TableInfo saveAndGetTableInfoByMapper(Class<?> mapperClass) {
        if (mapperClass == null) {
            return null;
        }
        if (this.mapperTableInfoMap.containsKey(mapperClass)) {
            return this.mapperTableInfoMap.get(mapperClass);
        }
        Class<?> modelClass = MybatisClassUtils.extractModelClass(mapperClass);
        if (modelClass == null) {
            return null;
        }
        TableInfo tableInfo = this.saveAndGetTableInfoByModel(modelClass);
        if (tableInfo != null) {
            this.mapperTableInfoMap.putIfAbsent(mapperClass, tableInfo);
            this.mapperRegistryCache.add(mapperClass.getName());
            return this.mapperTableInfoMap.get(mapperClass);
        }
        return null;
    }

    public TableInfo saveAndGetTableInfoByModel(Class<?> modelClass) {
        if (modelClass == null || modelClass.isInterface()) {
            return null;
        }
        if (this.modelTableInfoMap.containsKey(modelClass)) {
            return this.modelTableInfoMap.get(modelClass);
        }
        if (!this.isModelClassInScanPackage(modelClass)) {
            return null;
        }
        TableInfo tableInfo = MybatisTableInfoHelper.parseTableInfo(this, modelClass);
        this.modelTableInfoMap.putIfAbsent(modelClass, tableInfo);
        return this.modelTableInfoMap.get(modelClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WhereLogicInfo saveAndGetWhereLogic(Class<?> whereLogicCls) {
        if (whereLogicCls == null) {
            return null;
        }
        WhereLogicInfo whereLogicInfo = this.whereLogicInfoMap.get(whereLogicCls);
        if (whereLogicInfo != null) {
            return whereLogicInfo;
        }
        if (this.excludeWhereLogicType.contains(whereLogicCls.getName())) {
            return null;
        }
        Class<?> clazz = whereLogicCls;
        synchronized (clazz) {
            whereLogicInfo = this.whereLogicInfoMap.get(whereLogicCls);
            if (whereLogicInfo != null) {
                return whereLogicInfo;
            }
            if (this.excludeWhereLogicType.contains(whereLogicCls.getName())) {
                return null;
            }
            whereLogicInfo = MybatisWhereLogicHelper.parseWhereLogicInfo(this, whereLogicCls);
            if (whereLogicInfo == null) {
                this.excludeWhereLogicType.add(whereLogicCls.getName());
                return null;
            }
            this.whereLogicInfoMap.put(whereLogicCls, whereLogicInfo);
        }
        return this.whereLogicInfoMap.get(whereLogicCls);
    }

    public String formatColumn(String property) {
        Preconditions.checkNotNull((Object)property, (Object)"column is null!");
        if (this.isDbColumnUnderline()) {
            property = MybatisStringUtils.camelToUnderline(this.dbColumnPrefix, property, this.dbColumnSuffix);
        }
        if (this.isCapitalMode) {
            property = property.toUpperCase();
        }
        return property;
    }

    public String formatTableName(String tableName) {
        return this.formatColumn(tableName);
    }

    public boolean enableInDefaultUpdateMethod(String propertyName) {
        return !this.disabledPropertyInDefaultUpdateMethod.contains(propertyName);
    }

    public void addDisabledPropertyInDefaultUpdateMethod(Collection<String> properties) {
        if (properties != null) {
            this.disabledPropertyInDefaultUpdateMethod.addAll(properties);
        }
    }

    private boolean isModelClassInScanPackage(Class<?> modelClazz) {
        Preconditions.checkNotNull(modelClazz, (Object)"class is null!");
        if (MybatisClassUtils.excludeClazzPrefix4ModelParseStatic(modelClazz)) {
            return false;
        }
        if (this.ignoreScanPackages) {
            return true;
        }
        if (this.packageNames == null) {
            throw new IllegalStateException("not scan package!");
        }
        String modelName = modelClazz.getName();
        for (String packageName : this.packageNames) {
            if (!modelName.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidModel(Class<?> modelClass) {
        return this.modelTableInfoMap.contains(modelClass);
    }
}

