/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.entity;

import com.econage.core.db.mybatis.MybatisException;
import com.econage.core.db.mybatis.adaptation.MybatisGlobalAssistant;
import com.econage.core.db.mybatis.annotations.KeySequence;
import com.econage.core.db.mybatis.annotations.TableDef;
import com.econage.core.db.mybatis.annotations.TableField;
import com.econage.core.db.mybatis.annotations.TableId;
import com.econage.core.db.mybatis.entity.TableFieldInfo;
import com.econage.core.db.mybatis.entity.TableInfo;
import com.econage.core.db.mybatis.enums.IdType;
import com.econage.core.db.mybatis.util.MybatisClassUtils;
import com.econage.core.db.mybatis.util.MybatisCollectionUtils;
import com.econage.core.db.mybatis.util.MybatisReflectionKit;
import com.econage.core.db.mybatis.util.MybatisSqlReservedWords;
import com.econage.core.db.mybatis.util.MybatisSqlUtils;
import com.econage.core.db.mybatis.util.MybatisStringUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class MybatisTableInfoHelper {
    private static final Log logger = LogFactory.getLog(MybatisTableInfoHelper.class);
    private static final String DEFAULT_ID_PROPERTY = "id";

    public static TableInfo parseTableInfo(MybatisGlobalAssistant globalAssistant, Class<?> modelClass) {
        Preconditions.checkNotNull(modelClass, (Object)"model class is null!");
        TableInfo tableInfo = new TableInfo();
        tableInfo.setModelClass(modelClass);
        TableDef table = modelClass.getAnnotation(TableDef.class);
        String tableName = modelClass.getSimpleName();
        tableName = table != null && MybatisStringUtils.isNotEmpty(table.value()) ? table.value() : globalAssistant.formatTableName(tableName);
        tableInfo.setTableName(tableName);
        if (null != globalAssistant.getKeyGenerator()) {
            tableInfo.setKeySequence(modelClass.getAnnotation(KeySequence.class));
        }
        if (table != null && !Strings.isNullOrEmpty((String)table.defaultSelectResultMap())) {
            tableInfo.setDefaultSelectResultMap(table.defaultSelectResultMap());
        }
        ArrayList fieldList = Lists.newArrayList();
        List<Field> list = MybatisTableInfoHelper.getAllFields(globalAssistant, modelClass);
        boolean isReadPK = false;
        boolean existTableId = MybatisTableInfoHelper.existTableId(list);
        for (Field field : list) {
            if (!isReadPK && (isReadPK = existTableId ? MybatisTableInfoHelper.initTableId(globalAssistant, tableInfo, field, modelClass) : MybatisTableInfoHelper.initFieldId(globalAssistant, tableInfo, field, modelClass))) continue;
            TableFieldInfo tableFieldInfo = MybatisTableInfoHelper.parseTableFieldByAnnotation(globalAssistant, field, modelClass);
            if (tableFieldInfo == null) {
                tableFieldInfo = TableFieldInfo.newTableFieldInfo(globalAssistant, field);
            }
            if (tableFieldInfo.isFk()) {
                tableInfo.setFkField(tableFieldInfo);
            }
            if (tableFieldInfo.isVersion()) {
                tableInfo.setVersionField(tableFieldInfo);
            }
            if (tableFieldInfo.isTreeParentLink()) {
                tableInfo.setTreeParentLinkField(tableFieldInfo);
            }
            if (tableFieldInfo.isTreeSiblingOrder()) {
                tableInfo.setTreeSiblingOrderField(tableFieldInfo);
            }
            fieldList.add(tableFieldInfo);
        }
        tableInfo.setFieldList(fieldList);
        tableInfo.setSelectColumns(MybatisTableInfoHelper.sqlSelectColumns(tableInfo));
        if (MybatisStringUtils.isEmpty(tableInfo.getKeyColumn())) {
            logger.warn(String.format("Warn: Could not find @TableId in Class: %s.", modelClass.getName()));
        }
        return tableInfo;
    }

    public static boolean existTableId(List<Field> list) {
        boolean exist = false;
        for (Field field : list) {
            TableId tableId = field.getAnnotation(TableId.class);
            if (tableId == null) continue;
            exist = true;
            break;
        }
        return exist;
    }

    private static boolean initTableId(MybatisGlobalAssistant globalAssistant, TableInfo tableInfo, Field field, Class<?> clazz) {
        TableId tableId = field.getAnnotation(TableId.class);
        if (tableId != null) {
            if (MybatisStringUtils.isNotEmpty(tableInfo.getKeyProperty())) {
                MybatisTableInfoHelper.throwExceptionId(clazz);
            }
            if (IdType.NONE != tableId.type()) {
                tableInfo.setIdType(tableId.type());
            } else if (tableInfo.getKeySequence() == null) {
                tableInfo.setIdType(globalAssistant.getDefaultIdType());
            }
            tableInfo.setKeyProperty(field.getName());
            tableInfo.setKeyAutoMappingColumn(globalAssistant.formatColumn(tableInfo.getKeyProperty()));
            if (MybatisStringUtils.isNotEmpty(tableId.value())) {
                tableInfo.setKeyColumn(MybatisSqlReservedWords.convert(globalAssistant, tableId.value()));
            } else {
                tableInfo.setKeyAutoMapping(true);
                tableInfo.setKeyColumn(tableInfo.getKeyAutoMappingColumn());
            }
            return true;
        }
        return false;
    }

    private static boolean initFieldId(MybatisGlobalAssistant globalAssistant, TableInfo tableInfo, Field field, Class<?> clazz) {
        String property = field.getName();
        if (DEFAULT_ID_PROPERTY.equalsIgnoreCase(property)) {
            if (MybatisStringUtils.isEmpty(tableInfo.getKeyProperty())) {
                if (tableInfo.getKeySequence() == null) {
                    tableInfo.setIdType(globalAssistant.getDefaultIdType());
                }
                tableInfo.setKeyProperty(property);
                tableInfo.setKeyAutoMapping(true);
                tableInfo.setKeyAutoMappingColumn(globalAssistant.formatColumn(property));
                tableInfo.setKeyColumn(tableInfo.getKeyAutoMappingColumn());
                return true;
            }
            MybatisTableInfoHelper.throwExceptionId(clazz);
        }
        return false;
    }

    private static void throwExceptionId(Class<?> clazz) {
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("There must be only one, Discover multiple @TableId annotation in ");
        errorMsg.append(clazz.getName());
        throw new MybatisException(errorMsg.toString());
    }

    private static TableFieldInfo parseTableFieldByAnnotation(MybatisGlobalAssistant globalAssistant, Field field, Class<?> clazz) {
        TableField tableField = field.getAnnotation(TableField.class);
        if (tableField != null) {
            return TableFieldInfo.newTableFieldInfoByAnnotation(globalAssistant, field, tableField);
        }
        return null;
    }

    private static List<Field> getAllFields(MybatisGlobalAssistant globalAssistant, Class<?> modelClass) {
        TypeHandlerRegistry typeHandlerRegistry = globalAssistant.getConfiguration().getTypeHandlerRegistry();
        List<Field> fieldList = MybatisReflectionKit.getFieldList(MybatisClassUtils.getUserClass(modelClass));
        if (MybatisCollectionUtils.isNotEmpty(fieldList)) {
            Iterator<Field> iterator = fieldList.iterator();
            while (iterator.hasNext()) {
                Field field = iterator.next();
                TableField tableField = field.getAnnotation(TableField.class);
                if (!typeHandlerRegistry.hasTypeHandler(field.getType())) {
                    iterator.remove();
                    continue;
                }
                if (tableField == null || tableField.exist()) continue;
                iterator.remove();
            }
        }
        return fieldList;
    }

    private static String sqlSelectColumns(TableInfo tableInfo) {
        ArrayList columnList = Lists.newArrayList();
        if (tableInfo.getDefaultSelectResultMap() != null) {
            columnList.add("*");
        } else {
            if (MybatisStringUtils.isNotEmpty(tableInfo.getKeyProperty())) {
                if (tableInfo.isKeyAutoMapping()) {
                    columnList.add(tableInfo.getKeyColumn());
                } else {
                    columnList.add(tableInfo.getKeyColumn() + " AS " + tableInfo.getKeyAutoMappingColumn());
                }
            }
            if (tableInfo.getFieldList() != null) {
                for (TableFieldInfo tableFieldInfo : tableInfo.getFieldList()) {
                    if (tableFieldInfo.isAutoMapping()) {
                        columnList.add(tableFieldInfo.getColumn());
                        continue;
                    }
                    columnList.add(tableFieldInfo.getColumn() + " AS " + tableFieldInfo.getAutoMappingColumn());
                }
            }
        }
        return MybatisSqlUtils.COMMA_JOINER.join((Iterable)columnList);
    }
}

