/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.entity;

import com.econage.core.db.mybatis.adaptation.MybatisGlobalAssistant;
import com.econage.core.db.mybatis.annotations.TableField;
import com.econage.core.db.mybatis.enums.FieldStrategy;
import com.econage.core.db.mybatis.util.MybatisStringUtils;
import java.lang.reflect.Field;

public class TableFieldInfo {
    private boolean autoMapping;
    private String autoMappingColumn;
    private boolean fk;
    private boolean version;
    private boolean treeParentLink;
    private boolean treeSiblingOrder;
    private String column;
    private String property;
    private String el;
    private Class<?> propertyType;
    private FieldStrategy fieldStrategy = FieldStrategy.NOT_NULL;
    private boolean defaultInsert = true;
    private boolean defaultUpdate = true;

    public static TableFieldInfo newTableFieldInfoByAnnotation(MybatisGlobalAssistant globalAssistant, Field fieldInfo, TableField tableFieldAnnotation) {
        TableFieldInfo tableFieldInfo = new TableFieldInfo();
        tableFieldInfo.setAutoMappingColumn(globalAssistant.formatColumn(fieldInfo.getName()));
        if (MybatisStringUtils.isNotEmpty(tableFieldAnnotation.value())) {
            tableFieldInfo.setAutoMapping(false);
            tableFieldInfo.setColumn(tableFieldAnnotation.value());
        } else {
            tableFieldInfo.setAutoMapping(true);
            tableFieldInfo.setColumn(tableFieldInfo.getAutoMappingColumn());
        }
        tableFieldInfo.setProperty(fieldInfo.getName());
        tableFieldInfo.setPropertyType(fieldInfo.getType());
        if (MybatisStringUtils.isNotEmpty(tableFieldAnnotation.el())) {
            tableFieldInfo.setEl(tableFieldAnnotation.el());
        } else {
            tableFieldInfo.setEl(tableFieldInfo.getProperty());
        }
        if (FieldStrategy.NOT_NULL != tableFieldAnnotation.strategy()) {
            tableFieldInfo.setFieldStrategy(tableFieldAnnotation.strategy());
        } else {
            tableFieldInfo.setFieldStrategy(globalAssistant.getDefaultFieldStrategy());
        }
        tableFieldInfo.setDefaultInsert(tableFieldAnnotation.defaultInsert());
        tableFieldInfo.setDefaultUpdate(tableFieldAnnotation.defaultUpdate());
        tableFieldInfo.setFk(tableFieldAnnotation.isFk());
        tableFieldInfo.setVersion(tableFieldAnnotation.isVersion());
        tableFieldInfo.setTreeParentLink(tableFieldAnnotation.isTreeParentLink());
        tableFieldInfo.setTreeSiblingOrder(tableFieldAnnotation.isTreeSiblingOrder());
        return tableFieldInfo;
    }

    public static TableFieldInfo newTableFieldInfo(MybatisGlobalAssistant globalAssistant, Field field) {
        TableFieldInfo tableFieldInfo = new TableFieldInfo();
        tableFieldInfo.setAutoMappingColumn(globalAssistant.formatColumn(field.getName()));
        tableFieldInfo.setAutoMapping(true);
        tableFieldInfo.setColumn(tableFieldInfo.getAutoMappingColumn());
        tableFieldInfo.setProperty(field.getName());
        tableFieldInfo.setPropertyType(field.getType());
        tableFieldInfo.setEl(field.getName());
        tableFieldInfo.setFieldStrategy(globalAssistant.getDefaultFieldStrategy());
        tableFieldInfo.setDefaultUpdate(globalAssistant.enableInDefaultUpdateMethod(tableFieldInfo.getProperty()));
        return tableFieldInfo;
    }

    private TableFieldInfo() {
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getEl() {
        return this.el;
    }

    public void setEl(String el) {
        this.el = el;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    private void setPropertyType(Class<?> propertyType) {
        this.propertyType = propertyType;
    }

    public FieldStrategy getFieldStrategy() {
        return this.fieldStrategy;
    }

    private void setFieldStrategy(FieldStrategy fieldStrategy) {
        this.fieldStrategy = fieldStrategy;
    }

    public boolean isAutoMapping() {
        return this.autoMapping;
    }

    private void setAutoMapping(boolean autoMapping) {
        this.autoMapping = autoMapping;
    }

    public String getAutoMappingColumn() {
        return this.autoMappingColumn;
    }

    private void setAutoMappingColumn(String autoMappingColumn) {
        this.autoMappingColumn = autoMappingColumn;
    }

    public boolean isDefaultInsert() {
        return this.defaultInsert;
    }

    private void setDefaultInsert(boolean defaultInsert) {
        this.defaultInsert = defaultInsert;
    }

    public boolean isDefaultUpdate() {
        return this.defaultUpdate;
    }

    private void setDefaultUpdate(boolean defaultUpdate) {
        this.defaultUpdate = defaultUpdate;
    }

    public boolean isFk() {
        return this.fk;
    }

    private void setFk(boolean fk) {
        this.fk = fk;
    }

    public boolean isVersion() {
        return this.version;
    }

    private void setVersion(boolean version) {
        this.version = version;
    }

    public boolean isTreeParentLink() {
        return this.treeParentLink;
    }

    public void setTreeParentLink(boolean treeParentLink) {
        this.treeParentLink = treeParentLink;
    }

    public boolean isTreeSiblingOrder() {
        return this.treeSiblingOrder;
    }

    public void setTreeSiblingOrder(boolean treeSiblingOrder) {
        this.treeSiblingOrder = treeSiblingOrder;
    }
}

