/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.entity;

import com.econage.core.db.mybatis.annotations.KeySequence;
import com.econage.core.db.mybatis.entity.TableFieldInfo;
import com.econage.core.db.mybatis.enums.IdType;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class TableInfo {
    private IdType idType = IdType.NONE;
    private String tableName;
    private String defaultSelectResultMap;
    private boolean keyAutoMapping;
    private String keyAutoMappingColumn;
    private String keyProperty;
    private String keyColumn;
    private KeySequence keySequence;
    private List<TableFieldInfo> fieldList;
    private TableFieldInfo fkField;
    private TableFieldInfo versionField;
    private TableFieldInfo treeParentLinkField;
    private TableFieldInfo treeSiblingOrderField;
    private Map<String, TableFieldInfo> propertyFieldMap;
    private String selectColumns;
    private Class<?> modelClass;
    private static Function<TableFieldInfo, String> fetchFieldProperty = input -> {
        if (input != null) {
            return input.getProperty();
        }
        return null;
    };

    public IdType getIdType() {
        return this.idType;
    }

    void setIdType(IdType idType) {
        this.idType = idType;
    }

    public String getTableName() {
        return this.tableName;
    }

    void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getDefaultSelectResultMap() {
        return this.defaultSelectResultMap;
    }

    void setDefaultSelectResultMap(String defaultSelectResultMap) {
        this.defaultSelectResultMap = defaultSelectResultMap;
    }

    public boolean isKeyAutoMapping() {
        return this.keyAutoMapping;
    }

    void setKeyAutoMapping(boolean keyAutoMapping) {
        this.keyAutoMapping = keyAutoMapping;
    }

    public String getKeyAutoMappingColumn() {
        return this.keyAutoMappingColumn;
    }

    void setKeyAutoMappingColumn(String keyAutoMappingColumn) {
        this.keyAutoMappingColumn = keyAutoMappingColumn;
    }

    public String getKeyProperty() {
        return this.keyProperty;
    }

    void setKeyProperty(String keyProperty) {
        this.keyProperty = keyProperty;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    void setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
    }

    public KeySequence getKeySequence() {
        return this.keySequence;
    }

    void setKeySequence(KeySequence keySequence) {
        this.keySequence = keySequence;
    }

    public List<TableFieldInfo> getFieldList() {
        return this.fieldList;
    }

    void setFieldList(List<TableFieldInfo> fieldList) {
        this.fieldList = ImmutableList.copyOf(fieldList);
        this.propertyFieldMap = Maps.uniqueIndex(fieldList, fetchFieldProperty);
    }

    public String getAutoMappingColumnByProperty(String property) {
        Preconditions.checkNotNull((Object)property, (Object)"property is null!");
        TableFieldInfo tableFieldInfo = this.propertyFieldMap.get(property);
        if (tableFieldInfo != null) {
            return tableFieldInfo.getAutoMappingColumn();
        }
        if (this.keyProperty != null && this.keyProperty.equals(property)) {
            return this.keyColumn;
        }
        return null;
    }

    public Class<?> getModelClass() {
        return this.modelClass;
    }

    void setModelClass(Class<?> modelClass) {
        this.modelClass = modelClass;
    }

    public String getSelectColumns() {
        return this.selectColumns;
    }

    void setSelectColumns(String selectColumns) {
        this.selectColumns = selectColumns;
    }

    public TableFieldInfo getVersionField() {
        return this.versionField;
    }

    void setVersionField(TableFieldInfo versionField) {
        this.versionField = versionField;
    }

    public TableFieldInfo getFkField() {
        return this.fkField;
    }

    void setFkField(TableFieldInfo fkField) {
        this.fkField = fkField;
    }

    public String getFkProperty() {
        if (this.fkField != null) {
            return this.fkField.getProperty();
        }
        return "";
    }

    public String getFkColumn() {
        if (this.fkField != null) {
            return this.fkField.getColumn();
        }
        return "";
    }

    public TableFieldInfo getTreeParentLinkField() {
        return this.treeParentLinkField;
    }

    void setTreeParentLinkField(TableFieldInfo treeParentLinkField) {
        this.treeParentLinkField = treeParentLinkField;
    }

    public String getTreeParentLinkProperty() {
        if (this.treeParentLinkField != null) {
            return this.treeParentLinkField.getProperty();
        }
        return "";
    }

    public String getTreeParentLinkColumn() {
        if (this.treeParentLinkField != null) {
            return this.treeParentLinkField.getColumn();
        }
        return "";
    }

    public TableFieldInfo getTreeSiblingOrderField() {
        return this.treeSiblingOrderField;
    }

    void setTreeSiblingOrderField(TableFieldInfo treeSiblingOrderField) {
        this.treeSiblingOrderField = treeSiblingOrderField;
    }

    public String getTreeSiblingOrderProperty() {
        if (this.treeSiblingOrderField != null) {
            return this.treeSiblingOrderField.getProperty();
        }
        return "";
    }

    public String getTreeSiblingOrderColumn() {
        if (this.treeSiblingOrderField != null) {
            return this.treeSiblingOrderField.getColumn();
        }
        return "";
    }
}

