/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.handlers;

import com.econage.core.db.mybatis.enums.IEnum;
import com.econage.core.db.mybatis.util.MybatisIEnumUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.EnumTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class DefaultEnumTypeHandler<E extends Enum<E>>
extends BaseTypeHandler<E> {
    private final Class<E> type;
    private final EnumTypeHandler<E> mybatisDefaultEnumTypeHandler;
    private final boolean isIEnum;

    public DefaultEnumTypeHandler(Class<E> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.type = type;
        this.isIEnum = IEnum.class.isAssignableFrom(type);
        this.mybatisDefaultEnumTypeHandler = new EnumTypeHandler(type);
    }

    public void setNonNullParameter(PreparedStatement ps, int i, E parameter, JdbcType jdbcType) throws SQLException {
        if (this.isIEnum) {
            IEnum iEnum = (IEnum)parameter;
            if (jdbcType == null) {
                ps.setObject(i, iEnum.getValue());
            } else {
                ps.setObject(i, (Object)iEnum.getValue(), jdbcType.TYPE_CODE);
            }
        } else {
            this.mybatisDefaultEnumTypeHandler.setNonNullParameter(ps, i, parameter, jdbcType);
        }
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        if (null == rs.getString(columnName) && rs.wasNull()) {
            return null;
        }
        if (this.isIEnum) {
            return (E)((Enum)((Object)MybatisIEnumUtils.valueOf(this.type, rs.getObject(columnName))));
        }
        return (E)this.mybatisDefaultEnumTypeHandler.getNullableResult(rs, columnName);
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        if (null == rs.getString(columnIndex) && rs.wasNull()) {
            return null;
        }
        if (this.isIEnum) {
            return (E)((Enum)((Object)MybatisIEnumUtils.valueOf(this.type, rs.getObject(columnIndex))));
        }
        return (E)this.mybatisDefaultEnumTypeHandler.getNullableResult(rs, columnIndex);
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        if (null == cs.getString(columnIndex) && cs.wasNull()) {
            return null;
        }
        if (this.isIEnum) {
            return (E)((Enum)((Object)MybatisIEnumUtils.valueOf(this.type, cs.getObject(columnIndex))));
        }
        return (E)this.mybatisDefaultEnumTypeHandler.getNullableResult(cs, columnIndex);
    }
}

