/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.handlers;

import com.econage.core.db.mybatis.util.MybatisStringUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class LocaleTypeHandler
extends BaseTypeHandler<Locale> {
    public void setNonNullParameter(PreparedStatement ps, int i, Locale parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, parameter.toString());
    }

    public Locale getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String localeStr = rs.getString(columnName);
        return this.toLocale(localeStr);
    }

    public Locale getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String localeStr = rs.getString(columnIndex);
        return this.toLocale(localeStr);
    }

    public Locale getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String localeStr = cs.getString(columnIndex);
        return this.toLocale(localeStr);
    }

    private Locale toLocale(String localeStr) {
        if (MybatisStringUtils.isEmpty(localeStr)) {
            return Locale.CHINA;
        }
        return LocaleUtils.toLocale((String)localeStr);
    }
}

