/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.mapper.base;

import com.econage.core.db.mybatis.adaptation.MybatisGlobalAssistant;
import com.econage.core.db.mybatis.entity.TableInfo;
import com.econage.core.db.mybatis.mapper.BaseMapper;
import com.econage.core.db.mybatis.mapper.base.insert.AbstractMethodSqlSource;
import com.econage.core.db.mybatis.mapper.base.insert.DefaultInsertMethodSqlSource;
import com.google.common.base.Preconditions;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;

public class SqlInjector {
    private static final Log logger = LogFactory.getLog(SqlInjector.class);
    private final MybatisGlobalAssistant globalAssistant;

    public SqlInjector(MybatisGlobalAssistant globalAssistant) {
        this.globalAssistant = globalAssistant;
    }

    public void inspectInject(MapperBuilderAssistant builderAssistant, Class<?> mapperClass) {
        TableInfo table;
        Preconditions.checkNotNull(mapperClass, (Object)"mapperclass is null!");
        if (!this.globalAssistant.isMapperParsed(mapperClass) && BaseMapper.class.isAssignableFrom(mapperClass) && (table = this.globalAssistant.saveAndGetTableInfoByMapper(mapperClass)) != null) {
            this.injectSql(builderAssistant, table);
        }
    }

    protected void injectSql(MapperBuilderAssistant builderAssistant, TableInfo table) {
        this.injectInsertOneSql(builderAssistant, table, false);
        this.injectInsertOneSql(builderAssistant, table, true);
    }

    protected void injectInsertOneSql(MapperBuilderAssistant builderAssistant, TableInfo table, boolean selective) {
        DefaultInsertMethodSqlSource sqlSource = new DefaultInsertMethodSqlSource(this.globalAssistant.getConfiguration(), table, selective);
        KeyGenerator keyGenerator = sqlSource.saveAndGetKeyGenerator(builderAssistant);
        if (keyGenerator == null) {
            this.addMappedStatement(builderAssistant, sqlSource, table.getModelClass(), null, Integer.class, (KeyGenerator)NoKeyGenerator.INSTANCE, null, null);
        } else {
            this.addMappedStatement(builderAssistant, sqlSource, table.getModelClass(), null, Integer.class, keyGenerator, table.getKeyProperty(), table.getKeyColumn());
        }
    }

    public MappedStatement addMappedStatement(MapperBuilderAssistant builderAssistant, AbstractMethodSqlSource sqlSource, Class<?> parameterClass, String resultMap, Class<?> resultType, KeyGenerator keyGenerator, String keyProperty, String keyColumn) {
        String mappedStatementId = builderAssistant.getCurrentNamespace() + "." + sqlSource.getMethodId();
        if (this.globalAssistant.getConfiguration().hasStatement(mappedStatementId)) {
            System.err.println("{" + mappedStatementId + "} Has been loaded by XML or SqlProvider, ignoring the injection of the SQL.");
            return null;
        }
        boolean isSelect = false;
        if (sqlSource.getSqlCommandType() == SqlCommandType.SELECT) {
            isSelect = true;
        }
        return builderAssistant.addMappedStatement(mappedStatementId, (SqlSource)sqlSource, StatementType.PREPARED, sqlSource.getSqlCommandType(), null, null, null, parameterClass, resultMap, resultType, null, !isSelect, isSelect, false, keyGenerator, keyProperty, keyColumn, null, this.globalAssistant.getConfiguration().getLanguageDriver(null), null);
    }
}

