/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.mapper.base;

import com.econage.core.db.mybatis.entity.TableFieldInfo;
import com.econage.core.db.mybatis.entity.TableInfo;
import com.econage.core.db.mybatis.enums.FieldStrategy;
import com.econage.core.db.mybatis.mapper.provider.MybatisProviderContext;
import com.econage.core.db.mybatis.util.MybatisCollectionUtils;
import com.econage.core.db.mybatis.util.MybatisSqlUtils;
import com.econage.core.db.mybatis.util.MybatisStringUtils;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.annotations.Param;

public class SqlProviderHelper {
    public static final String STATIC_WHERE_SQL_FRAGMENT = " where ";
    public static final String STATIC_FALSE_WHERE = " where  1<>1 ";

    public static String parseWhereLogic(MybatisProviderContext context, Object whereLogic) {
        if (whereLogic == null) {
            return STATIC_FALSE_WHERE;
        }
        List<String> wherePart = context.parseWhereLogic(whereLogic);
        if (MybatisCollectionUtils.isEmpty(wherePart)) {
            return STATIC_FALSE_WHERE;
        }
        return MybatisSqlUtils.wherePartJoin(STATIC_WHERE_SQL_FRAGMENT, wherePart);
    }

    public static String parseIdCollectionWherePart(MybatisProviderContext context, @Param(value="collection") Collection<? extends Serializable> idList) {
        TableInfo tableInfo = context.getTableInfo();
        return STATIC_WHERE_SQL_FRAGMENT + tableInfo.getKeyColumn() + " in ( " + context.formatCollection2ParameterMappings(tableInfo.getKeyProperty(), idList) + " )";
    }

    public static boolean useFieldInModifySql(TableFieldInfo fieldInfo, Class<?> propertyType, Object propertyVal) {
        boolean canUse = false;
        if (FieldStrategy.IGNORED == fieldInfo.getFieldStrategy()) {
            canUse = true;
        } else if (FieldStrategy.NOT_NULL == fieldInfo.getFieldStrategy()) {
            canUse = propertyVal != null;
        } else if (FieldStrategy.NOT_EMPTY == fieldInfo.getFieldStrategy()) {
            canUse = MybatisStringUtils.isCharSequence(propertyType) != false ? !Strings.isNullOrEmpty((String)((String)propertyVal)) : propertyVal != null;
        }
        return canUse;
    }
}

