/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.mapper.base.insert;

import com.econage.core.db.mybatis.adaptation.MybatisConfiguration;
import com.econage.core.db.mybatis.entity.TableInfo;
import com.econage.core.db.mybatis.mapper.base.insert.SqlProviderBinding;
import com.econage.core.db.mybatis.util.MybatisMapUtils;
import com.econage.core.db.mybatis.util.MybatisStringUtils;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.PropertyParser;
import org.apache.ibatis.session.Configuration;

public abstract class AbstractMethodSqlSource
implements SqlSource {
    private static final Log logger = LogFactory.getLog(AbstractMethodSqlSource.class);
    private final MybatisConfiguration configuration;
    private final SqlSourceBuilder sqlSourceParser;
    protected final TableInfo tableInfo;

    public AbstractMethodSqlSource(MybatisConfiguration configuration, TableInfo tableInfo) {
        this.configuration = configuration;
        this.sqlSourceParser = new SqlSourceBuilder((Configuration)configuration);
        this.tableInfo = tableInfo;
    }

    public final BoundSql getBoundSql(Object parameterObject) {
        SqlProviderBinding sqlProviderBinding = this.parseBinding(parameterObject);
        Map<String, Object> additionalParameter = sqlProviderBinding.getAdditionalParameter();
        Class parameterType = parameterObject == null ? Object.class : parameterObject.getClass();
        SqlSource sqlSource = this.sqlSourceParser.parse(this.replacePlaceholder(sqlProviderBinding.getSql()), parameterType, additionalParameter);
        BoundSql boundSql = sqlSource.getBoundSql(parameterObject);
        if (MybatisMapUtils.isNotEmpty(additionalParameter)) {
            for (Map.Entry<String, Object> entry : additionalParameter.entrySet()) {
                boundSql.setAdditionalParameter(entry.getKey(), entry.getValue());
            }
        }
        return boundSql;
    }

    protected abstract SqlProviderBinding parseBinding(Object var1);

    public abstract String getMethodId();

    public abstract SqlCommandType getSqlCommandType();

    public MybatisConfiguration getConfiguration() {
        return this.configuration;
    }

    protected SqlSource createStaticSqlSource(String sql, Class<?> parameterType) {
        if (MybatisStringUtils.isEmpty(sql)) {
            throw new IllegalArgumentException("sql is empty or null!");
        }
        return this.sqlSourceParser.parse(this.replacePlaceholder(sql), parameterType, (Map)Maps.newHashMap());
    }

    private String replacePlaceholder(String sql) {
        return PropertyParser.parse((String)sql, (Properties)this.configuration.getVariables());
    }
}

