/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.mapper.base.insert;

import com.econage.core.db.mybatis.MybatisException;
import com.econage.core.db.mybatis.adaptation.MybatisConfiguration;
import com.econage.core.db.mybatis.entity.TableFieldInfo;
import com.econage.core.db.mybatis.entity.TableInfo;
import com.econage.core.db.mybatis.enums.IdType;
import com.econage.core.db.mybatis.enums.SqlMethod;
import com.econage.core.db.mybatis.mapper.base.SqlProviderHelper;
import com.econage.core.db.mybatis.mapper.base.insert.AbstractMethodSqlSource;
import com.econage.core.db.mybatis.mapper.base.insert.SqlProviderBinding;
import com.econage.core.db.mybatis.uid.dbincrementer.IKeyGenerator;
import com.econage.core.db.mybatis.util.MybatisSqlUtils;
import com.econage.core.db.mybatis.util.MybatisStringUtils;
import com.econage.core.db.mybatis.uuid.IdWorker;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.reflection.MetaObject;

public class DefaultInsertMethodSqlSource
extends AbstractMethodSqlSource {
    public static final String INSERT_SQL_TEMPLATE = "insert into %s (%s) values (%s)";
    private final boolean selective;
    private KeyGenerator keyGenerator;
    private boolean saveAndGetKeyGeneratorRun;

    public DefaultInsertMethodSqlSource(MybatisConfiguration configuration, TableInfo tableInfo, boolean selective) {
        super(configuration, tableInfo);
        this.selective = selective;
    }

    public KeyGenerator saveAndGetKeyGenerator(MapperBuilderAssistant mapperBuilder) {
        if (this.keyGenerator == null && MybatisStringUtils.isNotEmpty(this.tableInfo.getKeyProperty())) {
            if (this.tableInfo.getIdType() == IdType.AUTO) {
                this.keyGenerator = new Jdbc3KeyGenerator();
            } else if (null != this.tableInfo.getKeySequence()) {
                this.keyGenerator = this.genKeyGenerator(mapperBuilder);
            }
        }
        this.saveAndGetKeyGeneratorRun = true;
        return this.keyGenerator;
    }

    private KeyGenerator genKeyGenerator(MapperBuilderAssistant builderAssistant) {
        IKeyGenerator keyGenerator = this.getConfiguration().getGlobalAssistant().getKeyGenerator();
        if (null == keyGenerator) {
            throw new IllegalArgumentException("not configure IKeyGenerator implementation class.");
        }
        String selectKeyGeneratorId = this.getMethodId() + "!selectKey";
        Class resultTypeClass = this.tableInfo.getKeySequence().clazz();
        String keyProperty = this.tableInfo.getKeyProperty();
        String keyColumn = this.tableInfo.getKeyColumn();
        SqlSource sqlSource = this.createStaticSqlSource(keyGenerator.executeSql(this.tableInfo.getKeySequence().value()), resultTypeClass);
        builderAssistant.addMappedStatement(selectKeyGeneratorId, sqlSource, StatementType.PREPARED, SqlCommandType.SELECT, null, null, null, null, null, resultTypeClass, null, false, false, false, (KeyGenerator)NoKeyGenerator.INSTANCE, keyProperty, keyColumn, null, this.getConfiguration().getLanguageDriver(null), null);
        selectKeyGeneratorId = builderAssistant.applyCurrentNamespace(selectKeyGeneratorId, false);
        MappedStatement keyStatement = builderAssistant.getConfiguration().getMappedStatement(selectKeyGeneratorId, false);
        SelectKeyGenerator selectKeyGenerator = new SelectKeyGenerator(keyStatement, true);
        builderAssistant.getConfiguration().addKeyGenerator(selectKeyGeneratorId, (KeyGenerator)selectKeyGenerator);
        return selectKeyGenerator;
    }

    @Override
    protected SqlProviderBinding parseBinding(Object entityObject) {
        Preconditions.checkNotNull((Object)entityObject, (Object)"can not insert null object!");
        if (entityObject instanceof Map) {
            entityObject = ((Map)entityObject).get("et");
        }
        MetaObject entityMetaObject = this.getConfiguration().newMetaObject(entityObject);
        ArrayList columns = Lists.newArrayList();
        ArrayList parameterTokens = Lists.newArrayList();
        if (!this.saveAndGetKeyGeneratorRun) {
            throw new IllegalStateException("not try save KeyGenerator!");
        }
        TableFieldInfo versionField = this.tableInfo.getVersionField();
        if (versionField != null) {
            String property = versionField.getProperty();
            Class propertyType = entityMetaObject.getGetterType(property);
            Object propertyVal = entityMetaObject.getValue(versionField.getProperty());
            if (!MybatisStringUtils.isCharSequence(propertyType).booleanValue()) {
                throw new MybatisException("version property type error,expected:CharSequence,actual[" + (String)property + "]!");
            }
            if (propertyVal == null) {
                entityMetaObject.setValue(versionField.getProperty(), (Object)IdWorker.getIdStr());
            }
        }
        this.parseId(entityMetaObject, columns, parameterTokens);
        for (TableFieldInfo fieldInfo : this.tableInfo.getFieldList()) {
            String property = fieldInfo.getProperty();
            if (!fieldInfo.isDefaultInsert()) continue;
            Class propertyType = entityMetaObject.getGetterType(property);
            Object propertyVal = entityMetaObject.getValue(property);
            if (propertyType != fieldInfo.getPropertyType()) {
                throw new IllegalArgumentException("inconsistent parameter property type");
            }
            if (this.selective && !SqlProviderHelper.useFieldInModifySql(fieldInfo, propertyType, propertyVal)) continue;
            columns.add(fieldInfo.getColumn());
            parameterTokens.add("#{et." + fieldInfo.getEl() + "}");
        }
        String sql = String.format(INSERT_SQL_TEMPLATE, this.tableInfo.getTableName(), MybatisSqlUtils.commaJoin(columns), MybatisSqlUtils.commaJoin(parameterTokens));
        return SqlProviderBinding.of(sql);
    }

    private void parseId(MetaObject entityMetaObject, List<String> columns, List<String> parameterTokens) {
        Object idValue;
        if (MybatisStringUtils.isEmpty(this.tableInfo.getKeyProperty())) {
            return;
        }
        if (this.tableInfo.getIdType() == IdType.AUTO || this.tableInfo.getIdType() == null) {
            return;
        }
        if (null == this.tableInfo.getKeySequence() && MybatisStringUtils.checkValNull(idValue = entityMetaObject.getValue(this.tableInfo.getKeyProperty()))) {
            if (this.tableInfo.getIdType() == IdType.ID_WORKER) {
                entityMetaObject.setValue(this.tableInfo.getKeyProperty(), (Object)IdWorker.getIdStr());
            } else if (this.tableInfo.getIdType() == IdType.UUID) {
                entityMetaObject.setValue(this.tableInfo.getKeyProperty(), (Object)IdWorker.get32UUID());
            }
        }
        columns.add(this.tableInfo.getKeyColumn());
        parameterTokens.add("#{et." + this.tableInfo.getKeyProperty() + "}");
    }

    @Override
    public String getMethodId() {
        if (this.selective) {
            return SqlMethod.INSERT.getMethod();
        }
        return SqlMethod.INSERT_ALL_COLUMN.getMethod();
    }

    @Override
    public SqlCommandType getSqlCommandType() {
        return SqlCommandType.INSERT;
    }
}

