/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.mapper.base.rud;

import com.econage.core.db.mybatis.MybatisException;
import com.econage.core.db.mybatis.entity.TableInfo;
import com.econage.core.db.mybatis.mapper.base.SqlProviderHelper;
import com.econage.core.db.mybatis.mapper.provider.MybatisProviderContext;
import com.econage.core.db.mybatis.util.MybatisCollectionUtils;
import java.io.Serializable;
import java.util.Collection;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.builder.annotation.ProviderMethodResolver;

public class BaseSelectProvider
implements ProviderMethodResolver {
    public static String selectById(MybatisProviderContext context) {
        TableInfo tableInfo = context.getTableInfo();
        return "select " + tableInfo.getSelectColumns() + " from " + tableInfo.getTableName() + " where " + tableInfo.getKeyColumn() + "=#{" + tableInfo.getKeyProperty() + "}";
    }

    public static String selectListByIds(MybatisProviderContext context, @Param(value="collection") Collection<? extends Serializable> idList) {
        TableInfo tableInfo = context.getTableInfo();
        StringBuilder sqlBuf = new StringBuilder().append("select ").append(tableInfo.getSelectColumns()).append(" from ").append(tableInfo.getTableName());
        if (MybatisCollectionUtils.isEmpty(idList)) {
            return sqlBuf.append(" where  1<>1 ").toString();
        }
        return sqlBuf.append(SqlProviderHelper.parseIdCollectionWherePart(context, idList)).toString();
    }

    public static String selectListByPage(MybatisProviderContext context) {
        TableInfo tableInfo = context.getTableInfo();
        return "select " + tableInfo.getSelectColumns() + " from " + tableInfo.getTableName();
    }

    public static String selectCountAll(MybatisProviderContext context) {
        return "select count(1)  from " + context.getTableName();
    }

    public static String selectListByFk(MybatisProviderContext context, @Param(value="collection") Collection<? extends Serializable> fkCollection) {
        TableInfo tableInfo = context.getTableInfo();
        StringBuilder sqlBuf = new StringBuilder().append("select ").append(tableInfo.getSelectColumns()).append(" from ").append(tableInfo.getTableName());
        if (MybatisCollectionUtils.isEmpty(fkCollection)) {
            return sqlBuf.append(" where  1<>1 ").toString();
        }
        if (tableInfo.getFkField() == null) {
            throw new MybatisException("Could not find fkField on table.Possibly no @TableFk in Entity.");
        }
        return sqlBuf.append(" where ").append(tableInfo.getFkColumn()).append(" in (").append(context.formatCollection2ParameterMappings(tableInfo.getFkProperty(), fkCollection)).append(" ) ").toString();
    }

    public static String selectListByWhereLogic(MybatisProviderContext context, @Param(value="wl") Object whereLogic, @Param(value="param1") Object obj) {
        return BaseSelectProvider.doSelectByWhereLogic(context, whereLogic, context.getSelectColumns());
    }

    public static String selectCountByWhereLogic(MybatisProviderContext context, @Param(value="wl") Object whereLogic, @Param(value="param1") Object obj) {
        return BaseSelectProvider.doSelectByWhereLogic(context, whereLogic, "COUNT(1)");
    }

    private static String doSelectByWhereLogic(MybatisProviderContext context, Object whereLogic, String selectCols) {
        return " select " + selectCols + " from " + context.getTableName() + SqlProviderHelper.parseWhereLogic(context, whereLogic);
    }
}

