/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.mapper.base.rud;

import com.econage.core.db.mybatis.MybatisException;
import com.econage.core.db.mybatis.entity.TableFieldInfo;
import com.econage.core.db.mybatis.entity.TableInfo;
import com.econage.core.db.mybatis.mapper.base.SqlProviderHelper;
import com.econage.core.db.mybatis.mapper.provider.MybatisProviderContext;
import com.econage.core.db.mybatis.util.MybatisSqlUtils;
import com.econage.core.db.mybatis.util.MybatisStringUtils;
import com.econage.core.db.mybatis.uuid.IdWorker;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.builder.annotation.ProviderMethodResolver;
import org.apache.ibatis.reflection.MetaObject;

public class BaseUpdateProvider
implements ProviderMethodResolver {
    public static String updateById(MybatisProviderContext context, @Param(value="et") Object entity, @Param(value="param1") Object obj) {
        MetaObject entityMetaObject = context.newMetaObject(entity);
        List<String> setParts = BaseUpdateProvider.parseSqlSetPartByEntity(context.getTableInfo(), entityMetaObject, true);
        return BaseUpdateProvider.doUpdateById(context, entityMetaObject, setParts);
    }

    public static String updateAllColumnById(MybatisProviderContext context, @Param(value="et") Object entity, @Param(value="param1") Object obj) {
        MetaObject entityMetaObject = context.newMetaObject(entity);
        List<String> setParts = BaseUpdateProvider.parseSqlSetPartByEntity(context.getTableInfo(), entityMetaObject, false);
        return BaseUpdateProvider.doUpdateById(context, entityMetaObject, setParts);
    }

    public static String updatePartialColumnById(MybatisProviderContext context, @Param(value="et") Object entity, @Param(value="pna") Collection<String> propertyNameArray) {
        MetaObject entityMetaObject = context.newMetaObject(entity);
        List<String> setParts = BaseUpdateProvider.parseSqlSetPartByPartialCol(context.getTableInfo(), entityMetaObject, propertyNameArray);
        return BaseUpdateProvider.doUpdateById(context, entityMetaObject, setParts);
    }

    private static String doUpdateById(MybatisProviderContext context, MetaObject entityMetaObject, List<String> setParts) {
        String wherePart;
        TableInfo tableInfo = context.getTableInfo();
        String pkColWherePart = tableInfo.getKeyColumn() + "=#{" + "et" + "." + tableInfo.getKeyProperty() + "}";
        TableFieldInfo versionField = context.getTableInfo().getVersionField();
        if (versionField != null) {
            ArrayList whereParts = Lists.newArrayList((Object[])new String[]{pkColWherePart});
            BaseUpdateProvider.handleVersion2SetOnBasic(context, entityMetaObject, versionField, setParts, whereParts);
            wherePart = MybatisSqlUtils.wherePartJoin(" where ", whereParts);
        } else {
            wherePart = " where " + pkColWherePart;
        }
        return " update " + context.getTableName() + " set " + MybatisSqlUtils.commaJoin(setParts) + wherePart;
    }

    private static void handleVersion2SetOnBasic(MybatisProviderContext context, MetaObject entityMetaObject, TableFieldInfo versionField, List<String> sqlSetsPart, List<String> sqlWherePart) {
        String property = versionField.getProperty();
        String currVersionProperty = property + "_curr_stamp__";
        Class propertyType = entityMetaObject.getGetterType(property);
        Object propertyVal = entityMetaObject.getValue(property);
        if (propertyVal == null) {
            throw new MybatisException("version is null,field:[" + property + "]!");
        }
        if (MybatisStringUtils.isCharSequence(propertyType).booleanValue() && MybatisStringUtils.isEmpty((String)propertyVal)) {
            throw new MybatisException("version is null or empty,field:[" + property + "]!");
        }
        String newVersionProperty = property + "_new_stamp__";
        String newVersionStamp = IdWorker.getIdStr();
        context.setAdditionalParam(newVersionProperty, newVersionStamp);
        context.setAdditionalParam(currVersionProperty, propertyVal);
        sqlSetsPart.add(versionField.getColumn() + "=#{" + newVersionProperty + "}");
        sqlWherePart.add(versionField.getColumn() + "=#{" + currVersionProperty + "}");
        entityMetaObject.setValue(property, (Object)newVersionStamp);
    }

    public static String updateBatchByWhereLogic(MybatisProviderContext context, @Param(value="et") Object entity, @Param(value="wl") Object whereLogic) {
        return BaseUpdateProvider.doUpdateBatchByWhereLogic(true, context, entity, whereLogic);
    }

    public static String updateBatchAllColumnByWhereLogic(MybatisProviderContext context, @Param(value="et") Object entity, @Param(value="wl") Object whereLogic) {
        return BaseUpdateProvider.doUpdateBatchByWhereLogic(false, context, entity, whereLogic);
    }

    private static String doUpdateBatchByWhereLogic(boolean selective, MybatisProviderContext context, Object entity, Object whereLogic) {
        MetaObject entityMetaObject = context.newMetaObject(entity);
        List<String> setParts = BaseUpdateProvider.parseSqlSetPartByEntity(context.getTableInfo(), entityMetaObject, selective);
        BaseUpdateProvider.handleVersion2SetOnBatch(context, entityMetaObject, setParts);
        return " update " + context.getTableName() + " set " + MybatisSqlUtils.commaJoin(setParts) + SqlProviderHelper.parseWhereLogic(context, whereLogic);
    }

    public static String updateBatchPartialColumnByWhereLogic(MybatisProviderContext context, @Param(value="et") Object entity, @Param(value="pna") Collection<String> propertyNameArray, @Param(value="wl") Object whereLogic) {
        MetaObject entityMetaObject = context.newMetaObject(entity);
        List<String> setParts = BaseUpdateProvider.parseSqlSetPartByPartialCol(context.getTableInfo(), entityMetaObject, propertyNameArray);
        BaseUpdateProvider.handleVersion2SetOnBatch(context, entityMetaObject, setParts);
        return " update " + context.getTableName() + " set " + MybatisSqlUtils.commaJoin(setParts) + SqlProviderHelper.parseWhereLogic(context, whereLogic);
    }

    private static void handleVersion2SetOnBatch(MybatisProviderContext context, MetaObject entityMetaObject, List<String> setParts) {
        TableFieldInfo versionField = context.getTableInfo().getVersionField();
        if (versionField == null) {
            return;
        }
        String property = versionField.getProperty();
        String newVersionProperty = property + "_new_stamp__";
        String newVersionStamp = IdWorker.getIdStr();
        context.setAdditionalParam(newVersionProperty, newVersionStamp);
        entityMetaObject.setValue(property, (Object)newVersionStamp);
        setParts.add(versionField.getColumn() + "=#{" + newVersionProperty + "}");
    }

    private static List<String> parseSqlSetPartByEntity(TableInfo tableInfo, MetaObject entityMetaObject, boolean selective) {
        ArrayList sqlSetsPart = Lists.newArrayList();
        TableFieldInfo versionField = tableInfo.getVersionField();
        for (TableFieldInfo fieldInfo : tableInfo.getFieldList()) {
            if (!fieldInfo.isDefaultUpdate()) continue;
            String property = fieldInfo.getProperty();
            Class propertyType = entityMetaObject.getGetterType(property);
            Object propertyVal = entityMetaObject.getValue(property);
            if (propertyType != fieldInfo.getPropertyType()) {
                throw new IllegalArgumentException("inconsistent parameter property type");
            }
            if (selective && !SqlProviderHelper.useFieldInModifySql(fieldInfo, propertyType, propertyVal) || versionField != null && property.equals(versionField.getProperty())) continue;
            sqlSetsPart.add(fieldInfo.getColumn() + "=#{" + "et" + "." + fieldInfo.getEl() + "}");
        }
        return sqlSetsPart;
    }

    private static List<String> parseSqlSetPartByPartialCol(TableInfo tableInfo, MetaObject entityMetaObject, Collection<String> partialProperty) {
        ArrayList sqlSetsPart = Lists.newArrayList();
        TableFieldInfo versionField = tableInfo.getVersionField();
        for (TableFieldInfo fieldInfo : tableInfo.getFieldList()) {
            String property = fieldInfo.getProperty();
            if (!partialProperty.contains(property)) continue;
            Class propertyType = entityMetaObject.getGetterType(property);
            if (propertyType != fieldInfo.getPropertyType()) {
                throw new IllegalArgumentException("inconsistent parameter property type");
            }
            if (versionField != null && property.equals(versionField.getProperty())) continue;
            sqlSetsPart.add(fieldInfo.getColumn() + "=#{" + "et" + "." + fieldInfo.getEl() + "}");
        }
        return sqlSetsPart;
    }
}

