/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.mapper.dyna.adaptation;

import com.econage.core.db.mybatis.MybatisException;
import com.econage.core.db.mybatis.mapper.dyna.entity.DynaBean;
import com.econage.core.db.mybatis.mapper.dyna.entity.DynaClass;
import com.econage.core.db.mybatis.mapper.dyna.entity.DynaColumn;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.result.DefaultResultContext;
import org.apache.ibatis.executor.result.DefaultResultHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.executor.resultset.ResultSetWrapper;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class DynaBeanResultSetHandler
implements ResultSetHandler {
    private final Executor executor;
    private final Configuration configuration;
    private final MappedStatement mappedStatement;
    private final RowBounds rowBounds;
    private final ParameterHandler parameterHandler;
    private final ResultHandler<?> resultHandler;
    private final BoundSql boundSql;
    private final TypeHandlerRegistry typeHandlerRegistry;
    private final ObjectFactory objectFactory;
    private final ReflectorFactory reflectorFactory;
    private final DynaClass dynaClass;

    public DynaBeanResultSetHandler(Executor executor, MappedStatement mappedStatement, ParameterHandler parameterHandler, ResultHandler<?> resultHandler, BoundSql boundSql, RowBounds rowBounds, DynaClass dynaClass) {
        this.executor = executor;
        this.configuration = mappedStatement.getConfiguration();
        this.mappedStatement = mappedStatement;
        this.rowBounds = rowBounds;
        this.parameterHandler = parameterHandler;
        this.boundSql = boundSql;
        this.dynaClass = dynaClass;
        this.typeHandlerRegistry = this.configuration.getTypeHandlerRegistry();
        this.objectFactory = this.configuration.getObjectFactory();
        this.reflectorFactory = this.configuration.getReflectorFactory();
        this.resultHandler = resultHandler;
    }

    public List<Object> handleResultSets(Statement stmt) throws SQLException {
        ErrorContext.instance().activity("handling results").object(this.mappedStatement.getId());
        ArrayList<Object> multipleResults = new ArrayList<Object>();
        ResultSetWrapper rsw = this.getFirstResultSet(stmt);
        this.validateResultMapsCount(rsw, this.mappedStatement.getResultMaps().size());
        if (rsw != null) {
            this.handleResultSet(rsw, multipleResults);
        }
        return this.collapseSingleResultList(multipleResults);
    }

    private List<Object> collapseSingleResultList(List<Object> multipleResults) {
        return multipleResults.size() == 1 ? (List)multipleResults.get(0) : multipleResults;
    }

    private ResultSetWrapper getFirstResultSet(Statement stmt) throws SQLException {
        ResultSet rs = stmt.getResultSet();
        while (rs == null) {
            if (stmt.getMoreResults()) {
                rs = stmt.getResultSet();
                continue;
            }
            if (stmt.getUpdateCount() != -1) continue;
        }
        return rs != null ? new ResultSetWrapper(rs, this.configuration) : null;
    }

    private void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void validateResultMapsCount(ResultSetWrapper rsw, int resultMapCount) {
        if (rsw != null && resultMapCount < 1) {
            throw new ExecutorException("A query was run and no Result Maps were found for the Mapped Statement '" + this.mappedStatement.getId() + "'.  It's likely that neither a Result Type nor a Result Map was specified.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResultSet(ResultSetWrapper rsw, List<Object> multipleResults) throws SQLException {
        try {
            if (this.resultHandler == null) {
                DefaultResultHandler defaultResultHandler = new DefaultResultHandler(this.objectFactory);
                this.handleRowValues(rsw, (ResultHandler<?>)defaultResultHandler);
                multipleResults.add(defaultResultHandler.getResultList());
            } else {
                this.handleRowValues(rsw, this.resultHandler);
            }
        }
        finally {
            this.closeResultSet(rsw.getResultSet());
        }
    }

    public void handleRowValues(ResultSetWrapper rsw, ResultHandler<?> resultHandler) throws SQLException {
        DefaultResultContext resultContext = new DefaultResultContext();
        ResultSet resultSet = rsw.getResultSet();
        while (!resultContext.isStopped() && !resultSet.isClosed() && resultSet.next()) {
            resultContext.nextResultObject((Object)this.getRowValue(rsw));
            resultHandler.handleResult((ResultContext)resultContext);
        }
    }

    private DynaBean getRowValue(ResultSetWrapper rsw) throws SQLException {
        DynaBean dynaBean = new DynaBean(this.dynaClass);
        for (DynaColumn dynaColumn : this.dynaClass.getDynaColumns()) {
            String columnName = dynaColumn.getName();
            TypeHandler typeHandler = this.typeHandlerRegistry.getTypeHandler(dynaColumn.getType(), rsw.getJdbcType(columnName));
            if (typeHandler != null) {
                dynaBean.set(columnName, typeHandler.getResult(rsw.getResultSet(), columnName));
                continue;
            }
            throw new MybatisException("Unrecognized type in handle dynaClass,type:[" + dynaColumn.getType() + "]");
        }
        return dynaBean;
    }

    public Cursor<Object> handleCursorResultSets(Statement stmt) throws SQLException {
        throw new UnsupportedOperationException("can't handle cursor in DynaBeanResultSetHandler");
    }

    public void handleOutputParameters(CallableStatement cs) throws SQLException {
        throw new UnsupportedOperationException("can't handle output parameter in DynaBeanResultSetHandler");
    }
}

