/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.mapper.dyna.entity;

import com.econage.core.db.mybatis.mapper.dyna.entity.DynaClass;
import com.econage.core.db.mybatis.mapper.dyna.entity.DynaColumn;
import java.util.HashMap;

public class DynaBean {
    private final DynaClass dynaClass;
    protected HashMap<String, Object> values = new HashMap();

    public DynaBean(DynaClass dynaClass) {
        this.dynaClass = dynaClass;
    }

    public boolean contains(String name) {
        return this.values.containsKey(name);
    }

    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    public Object get(String name) {
        Object value = this.values.get(name);
        if (value != null) {
            return value;
        }
        Class<?> type = this.getDynaProperty(name).getType();
        if (!type.isPrimitive()) {
            return value;
        }
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        return null;
    }

    public void set(String name, Object value) {
        DynaColumn descriptor = this.getDynaProperty(name);
        if (value == null) {
            if (descriptor.getType().isPrimitive()) {
                throw new NullPointerException("Primitive value for '" + name + "'");
            }
        } else if (!this.isAssignable(descriptor.getType(), value.getClass())) {
            throw new IllegalArgumentException("Cannot assign value of type '" + value.getClass().getName() + "' to property '" + name + "' of type '" + descriptor.getType().getName() + "'");
        }
        this.values.put(name, value);
    }

    protected DynaColumn getDynaProperty(String name) {
        DynaColumn descriptor = this.getDynaClass().getDynaProperty(name);
        if (descriptor == null) {
            throw new IllegalArgumentException("Invalid property name '" + name + "'");
        }
        return descriptor;
    }

    protected boolean isAssignable(Class<?> dest, Class<?> source) {
        return dest.isAssignableFrom(source) || dest == Boolean.TYPE && source == Boolean.class || dest == Byte.TYPE && source == Byte.class || dest == Character.TYPE && source == Character.class || dest == Double.TYPE && source == Double.class || dest == Float.TYPE && source == Float.class || dest == Integer.TYPE && source == Integer.class || dest == Long.TYPE && source == Long.class || dest == Short.TYPE && source == Short.class;
    }
}

