/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.mapper.dyna.entity;

import com.econage.core.db.mybatis.mapper.dyna.entity.DynaBean;
import com.econage.core.db.mybatis.mapper.dyna.entity.DynaColumn;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class DynaClass
implements Serializable {
    protected final String clsName;
    protected final String tableDef;
    protected final String idColumn;
    protected final String fkColumn;
    protected HashMap<String, DynaColumn> columnsMap = new HashMap();

    public DynaClass(String clsName, String idColumn, String fkColumn, String tableDef, Collection<DynaColumn> properties) {
        this.clsName = clsName;
        this.idColumn = idColumn;
        this.fkColumn = fkColumn;
        this.tableDef = tableDef;
        if (properties != null) {
            this.columnsMap.clear();
            for (DynaColumn property : properties) {
                this.columnsMap.put(property.getName(), property);
            }
        }
    }

    public String getClsName() {
        return this.clsName;
    }

    public String getTableDef() {
        return this.tableDef;
    }

    public String getIdColumn() {
        return this.idColumn;
    }

    public String getFkColumn() {
        return this.fkColumn;
    }

    public DynaColumn getDynaProperty(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("No property name specified");
        }
        return this.columnsMap.get(name);
    }

    public Collection<DynaColumn> getDynaColumns() {
        return ImmutableList.copyOf(this.columnsMap.values());
    }

    public DynaBean newInstance() {
        return new DynaBean(this);
    }
}

