/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.mapper.dyna.mapper;

import com.econage.core.db.mybatis.mapper.dyna.entity.DynaBean;
import com.econage.core.db.mybatis.mapper.dyna.entity.DynaClass;
import com.econage.core.db.mybatis.mapper.dyna.entity.DynaColumn;
import com.econage.core.db.mybatis.mapper.dyna.wherelogic.DynaWhereLogic;
import com.econage.core.db.mybatis.mapper.provider.MybatisProviderContext;
import com.econage.core.db.mybatis.util.MybatisSqlUtils;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.builder.annotation.ProviderMethodResolver;
import org.apache.ibatis.jdbc.SQL;

public class DynaBeanMapperProvider
implements ProviderMethodResolver {
    private static String formatPropertyInBoundSQL(String dynaPropertyName) {
        return "dynaEntity_" + dynaPropertyName;
    }

    public static String insert(MybatisProviderContext context, @Param(value="dynaCls") DynaClass dynaClass, @Param(value="dynaEntity") DynaBean entity) {
        SQL sql = (SQL)new SQL().INSERT_INTO(dynaClass.getTableDef());
        for (DynaColumn dynaColumn : dynaClass.getDynaColumns()) {
            String dynaColumnName = dynaColumn.getName();
            Object propertyVal = entity.get(dynaColumn.getName());
            String propertyInBoundSQL = DynaBeanMapperProvider.formatPropertyInBoundSQL(dynaColumnName);
            if (propertyVal == null) continue;
            context.setAdditionalParam(propertyInBoundSQL, propertyVal);
            sql.VALUES(dynaColumnName, MybatisSqlUtils.formatBoundParameter(propertyInBoundSQL));
        }
        return sql.toString();
    }

    public static String deleteById(@Param(value="dynaCls") DynaClass dynaClass, @Param(value="id") Serializable id) {
        return ((SQL)((SQL)new SQL().DELETE_FROM(dynaClass.getTableDef())).WHERE(dynaClass.getIdColumn() + " = " + MybatisSqlUtils.formatBoundParameter("id"))).toString();
    }

    public static String deleteByIds(MybatisProviderContext context, @Param(value="dynaCls") DynaClass dynaClass, @Param(value="ids") Collection<? extends Serializable> idList) {
        String idsFragment = context.formatCollection2ParameterMappings("ids", idList);
        return ((SQL)((SQL)new SQL().DELETE_FROM(dynaClass.getTableDef())).WHERE(dynaClass.getIdColumn() + " in (" + idsFragment + ")")).toString();
    }

    public static String deleteByFk(@Param(value="dynaCls") DynaClass dynaClass, @Param(value="fk") Serializable fk) {
        return ((SQL)((SQL)new SQL().DELETE_FROM(dynaClass.getTableDef())).WHERE(dynaClass.getFkColumn() + " = " + MybatisSqlUtils.formatBoundParameter("fk"))).toString();
    }

    public static String deleteByWhereLogic(MybatisProviderContext context, @Param(value="dynaCls") DynaClass dynaClass, @Param(value="wl") DynaWhereLogic whereLogic) {
        context.getAdditionalParam().putAll(whereLogic.getBoundParams());
        return ((SQL)((SQL)new SQL().DELETE_FROM(dynaClass.getTableDef())).WHERE(whereLogic.getBoundSqlArray())).toString();
    }

    public static String updateById(MybatisProviderContext context, @Param(value="dynaCls") DynaClass dynaClass, @Param(value="dynaEntity") DynaBean entity) {
        SQL sql = (SQL)new SQL().UPDATE(dynaClass.getTableDef());
        String idColumn = dynaClass.getIdColumn();
        for (DynaColumn dynaColumn : dynaClass.getDynaColumns()) {
            String dynaColumnName = dynaColumn.getName();
            Object propertyVal = entity.get(dynaColumn.getName());
            String propertyInBoundSQL = DynaBeanMapperProvider.formatPropertyInBoundSQL(dynaColumnName);
            if (StringUtils.equals((CharSequence)idColumn, (CharSequence)dynaColumnName)) {
                context.setAdditionalParam(propertyInBoundSQL, propertyVal);
                sql.WHERE(dynaColumnName + "=" + MybatisSqlUtils.formatBoundParameter(propertyInBoundSQL));
                continue;
            }
            if (propertyVal == null) continue;
            context.setAdditionalParam(propertyInBoundSQL, propertyVal);
            sql.SET(dynaColumnName + "=" + MybatisSqlUtils.formatBoundParameter(propertyInBoundSQL));
        }
        return sql.toString();
    }

    public static String updateAllColumnById(MybatisProviderContext context, @Param(value="dynaCls") DynaClass dynaClass, @Param(value="dynaEntity") DynaBean entity) {
        SQL sql = (SQL)new SQL().UPDATE(dynaClass.getTableDef());
        String idColumn = dynaClass.getIdColumn();
        for (DynaColumn dynaColumn : dynaClass.getDynaColumns()) {
            String dynaColumnName = dynaColumn.getName();
            Object propertyVal = entity.get(dynaColumn.getName());
            String propertyInBoundSQL = DynaBeanMapperProvider.formatPropertyInBoundSQL(dynaColumnName);
            if (StringUtils.equals((CharSequence)idColumn, (CharSequence)dynaColumnName)) {
                context.setAdditionalParam(propertyInBoundSQL, propertyVal);
                sql.WHERE(dynaColumnName + "=" + MybatisSqlUtils.formatBoundParameter(propertyInBoundSQL));
                continue;
            }
            context.setAdditionalParam(propertyInBoundSQL, propertyVal);
            sql.SET(dynaColumnName + "=" + MybatisSqlUtils.formatBoundParameter(propertyInBoundSQL));
        }
        return sql.toString();
    }

    public static String updatePartialColumnById(MybatisProviderContext context, @Param(value="dynaCls") DynaClass dynaClass, @Param(value="dynaEntity") DynaBean entity, @Param(value="dynaCna") Collection<String> propertyNameArray) {
        SQL sql = (SQL)new SQL().UPDATE(dynaClass.getTableDef());
        String idColumn = dynaClass.getIdColumn();
        for (DynaColumn dynaColumn : dynaClass.getDynaColumns()) {
            String dynaColumnName = dynaColumn.getName();
            Object propertyVal = entity.get(dynaColumn.getName());
            String propertyInBoundSQL = DynaBeanMapperProvider.formatPropertyInBoundSQL(dynaColumnName);
            if (StringUtils.equals((CharSequence)idColumn, (CharSequence)dynaColumnName)) {
                context.setAdditionalParam(propertyInBoundSQL, propertyVal);
                sql.WHERE(dynaColumnName + "=" + MybatisSqlUtils.formatBoundParameter(propertyInBoundSQL));
                continue;
            }
            if (!propertyNameArray.contains(dynaColumnName) || propertyVal == null) continue;
            context.setAdditionalParam(propertyInBoundSQL, propertyVal);
            sql.SET(dynaColumnName + "=" + MybatisSqlUtils.formatBoundParameter(propertyInBoundSQL));
        }
        return sql.toString();
    }

    public static String updateBatchByWhereLogic(MybatisProviderContext context, @Param(value="dynaCls") DynaClass dynaClass, @Param(value="dynaEntity") DynaBean entity, @Param(value="wl") DynaWhereLogic whereLogic) {
        SQL sql = (SQL)new SQL().UPDATE(dynaClass.getTableDef());
        String idColumn = dynaClass.getIdColumn();
        for (DynaColumn dynaColumn : dynaClass.getDynaColumns()) {
            String dynaColumnName = dynaColumn.getName();
            Object propertyVal = entity.get(dynaColumn.getName());
            if (StringUtils.equals((CharSequence)idColumn, (CharSequence)dynaColumnName) || propertyVal == null) continue;
            String propertyInBoundSQL = DynaBeanMapperProvider.formatPropertyInBoundSQL(dynaColumnName);
            context.setAdditionalParam(propertyInBoundSQL, propertyVal);
            sql.SET(dynaColumnName + "=" + MybatisSqlUtils.formatBoundParameter(propertyInBoundSQL));
        }
        sql.WHERE(whereLogic.getBoundSqlArray());
        context.getAdditionalParam().putAll(whereLogic.getBoundParams());
        return sql.toString();
    }

    public static String updateBatchAllColumnByWhereLogic(MybatisProviderContext context, @Param(value="dynaCls") DynaClass dynaClass, @Param(value="dynaEntity") DynaBean entity, @Param(value="wl") DynaWhereLogic whereLogic) {
        SQL sql = (SQL)new SQL().UPDATE(dynaClass.getTableDef());
        String idColumn = dynaClass.getIdColumn();
        for (DynaColumn dynaColumn : dynaClass.getDynaColumns()) {
            String dynaColumnName = dynaColumn.getName();
            Object propertyVal = entity.get(dynaColumn.getName());
            if (StringUtils.equals((CharSequence)idColumn, (CharSequence)dynaColumnName)) continue;
            String propertyInBoundSQL = DynaBeanMapperProvider.formatPropertyInBoundSQL(dynaColumnName);
            context.setAdditionalParam(propertyInBoundSQL, propertyVal);
            sql.SET(dynaColumnName + "=" + MybatisSqlUtils.formatBoundParameter(propertyInBoundSQL));
        }
        sql.WHERE(whereLogic.getBoundSqlArray());
        context.getAdditionalParam().putAll(whereLogic.getBoundParams());
        return sql.toString();
    }

    public static String updateBatchPartialColumnByWhereLogic(MybatisProviderContext context, @Param(value="dynaCls") DynaClass dynaClass, @Param(value="dynaEntity") DynaBean entity, @Param(value="dynaCna") Collection<String> propertyNameArray, @Param(value="wl") DynaWhereLogic whereLogic) {
        SQL sql = (SQL)new SQL().UPDATE(dynaClass.getTableDef());
        String idColumn = dynaClass.getIdColumn();
        for (DynaColumn dynaColumn : dynaClass.getDynaColumns()) {
            String dynaColumnName = dynaColumn.getName();
            Object propertyVal = entity.get(dynaColumn.getName());
            if (StringUtils.equals((CharSequence)idColumn, (CharSequence)dynaColumnName) || propertyVal == null || !propertyNameArray.contains(dynaColumnName)) continue;
            String propertyInBoundSQL = DynaBeanMapperProvider.formatPropertyInBoundSQL(dynaColumnName);
            context.setAdditionalParam(propertyInBoundSQL, propertyVal);
            sql.SET(dynaColumnName + "=" + MybatisSqlUtils.formatBoundParameter(propertyInBoundSQL));
        }
        sql.WHERE(whereLogic.getBoundSqlArray());
        context.getAdditionalParam().putAll(whereLogic.getBoundParams());
        return sql.toString();
    }

    public static String selectById(@Param(value="dynaCls") DynaClass dynaClass, @Param(value="id") Serializable id) {
        return ((SQL)((SQL)((SQL)new SQL().SELECT((String[])dynaClass.getDynaColumns().stream().map(DynaColumn::getName).toArray(String[]::new))).FROM(dynaClass.getTableDef())).WHERE(dynaClass.getIdColumn() + " = " + MybatisSqlUtils.formatBoundParameter("id"))).toString();
    }

    public static String selectListByIds(MybatisProviderContext context, @Param(value="dynaCls") DynaClass dynaClass, @Param(value="ids") Collection<? extends Serializable> idList) {
        String idsFragment = context.formatCollection2ParameterMappings("ids", idList);
        return ((SQL)((SQL)((SQL)new SQL().SELECT((String[])dynaClass.getDynaColumns().stream().map(DynaColumn::getName).toArray(String[]::new))).FROM(dynaClass.getTableDef())).WHERE(dynaClass.getIdColumn() + " in (" + idsFragment + ")")).toString();
    }

    public static String selectListByPage(@Param(value="dynaCls") DynaClass dynaClass) {
        return ((SQL)((SQL)new SQL().SELECT((String[])dynaClass.getDynaColumns().stream().map(DynaColumn::getName).toArray(String[]::new))).FROM(dynaClass.getTableDef())).toString();
    }

    public static String selectCountAll(@Param(value="dynaCls") DynaClass dynaClass) {
        return ((SQL)((SQL)new SQL().SELECT("count(1)")).FROM(dynaClass.getTableDef())).toString();
    }

    public static String selectListByFk(MybatisProviderContext context, @Param(value="dynaCls") DynaClass dynaClass, @Param(value="fks") Collection<? extends Serializable> fkCollection) {
        String fksFragment = context.formatCollection2ParameterMappings("fks", fkCollection);
        return ((SQL)((SQL)((SQL)new SQL().SELECT((String[])dynaClass.getDynaColumns().stream().map(DynaColumn::getName).toArray(String[]::new))).FROM(dynaClass.getTableDef())).WHERE(dynaClass.getIdColumn() + " in (" + fksFragment + ")")).toString();
    }

    public static String selectListByWhereLogic(MybatisProviderContext context, @Param(value="dynaCls") DynaClass dynaClass, @Param(value="wl") DynaWhereLogic whereLogic) {
        context.getAdditionalParam().putAll(whereLogic.getBoundParams());
        return ((SQL)((SQL)((SQL)new SQL().SELECT((String[])dynaClass.getDynaColumns().stream().map(DynaColumn::getName).toArray(String[]::new))).FROM(dynaClass.getTableDef())).WHERE(whereLogic.getBoundSqlArray())).toString();
    }

    public static String selectCountByWhereLogic(MybatisProviderContext context, @Param(value="dynaCls") DynaClass dynaClass, @Param(value="wl") DynaWhereLogic whereLogic) {
        context.getAdditionalParam().putAll(whereLogic.getBoundParams());
        return ((SQL)((SQL)((SQL)new SQL().SELECT("count(1)")).FROM(dynaClass.getTableDef())).WHERE(whereLogic.getBoundSqlArray())).toString();
    }
}

