/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.mapper.dyna.wherelogic;

import com.econage.core.db.mybatis.util.MybatisSqlUtils;
import com.econage.core.db.mybatis.uuid.IdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class DynaWhereLogic {
    private final List<String> boundSqlList = Lists.newArrayList();
    private final Map<String, Object> boundParams = Maps.newHashMap();

    private static String newDynaBoundSQLParamName() {
        return "dbp_" + IdWorker.getId();
    }

    public void addColumnEqIntoWhere(String column, Object object) {
        String dynaBoundParamName = DynaWhereLogic.newDynaBoundSQLParamName();
        this.boundSqlList.add(column + " = " + MybatisSqlUtils.formatBoundParameter(dynaBoundParamName));
        this.boundParams.put(dynaBoundParamName, object);
    }

    public void addColumnInCollectionIntoWhere(String column, Collection<Object> params) {
        ArrayList boundSqlParams = Lists.newArrayList();
        for (Object paramVal : params) {
            String dynaBoundParamName = DynaWhereLogic.newDynaBoundSQLParamName();
            boundSqlParams.add(MybatisSqlUtils.formatBoundParameter(dynaBoundParamName));
            this.boundParams.put(dynaBoundParamName, paramVal);
        }
        this.boundSqlList.add(column + " in (" + MybatisSqlUtils.commaJoin(boundSqlParams) + ") ");
    }

    public void addColumnFuzzyStrLikeIntoWhere(String column, String object) {
        String dynaBoundParamName = DynaWhereLogic.newDynaBoundSQLParamName();
        this.boundSqlList.add(column + " like CONCAT('%', " + MybatisSqlUtils.formatBoundParameter(dynaBoundParamName) + ", '%') ");
        this.boundParams.put(dynaBoundParamName, object);
    }

    public void addBoundSqlIntoWhere(String boundSQL, Map<String, Object> params) {
        this.boundSqlList.add(boundSQL);
        for (Map.Entry<String, Object> mapEntry : params.entrySet()) {
            if (this.boundParams.containsKey(mapEntry.getKey())) {
                throw new IllegalArgumentException("Duplicate key value:key[" + mapEntry.getKey() + "]");
            }
            this.boundParams.put(mapEntry.getKey(), mapEntry.getValue());
        }
    }

    public String formatWhere() {
        return MybatisSqlUtils.wherePartJoin(this.boundSqlList);
    }

    public List<String> getBoundSqlList() {
        return this.boundSqlList;
    }

    public String[] getBoundSqlArray() {
        return this.boundSqlList.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public Map<String, Object> getBoundParams() {
        return this.boundParams;
    }
}

