/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.mapper.provider;

import com.econage.core.db.mybatis.adaptation.MybatisConfiguration;
import com.econage.core.db.mybatis.entity.TableInfo;
import com.econage.core.db.mybatis.util.MybatisSqlUtils;
import com.econage.core.db.mybatis.wherelogic.MybatisWhereLogicHelper;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.reflection.MetaObject;

public final class MybatisProviderContext
implements Cloneable {
    private final MybatisConfiguration configuration;
    private final Class<?> mapperType;
    private final Method mapperMethod;
    private final String databaseId;
    private final TableInfo tableInfo;
    private Map<String, Object> additionalParam;

    MybatisProviderContext(MybatisConfiguration configuration, Class<?> mapperType, Method mapperMethod, String databaseId, TableInfo tableInfo) {
        this.configuration = configuration;
        this.mapperType = mapperType;
        this.mapperMethod = mapperMethod;
        this.databaseId = databaseId;
        this.tableInfo = tableInfo;
    }

    public Class<?> getMapperType() {
        return this.mapperType;
    }

    public Method getMapperMethod() {
        return this.mapperMethod;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public void setAdditionalParam(String key, Object object) {
        if (this.additionalParam == null) {
            this.additionalParam = Maps.newHashMap();
        }
        this.additionalParam.put(key, object);
    }

    public Map<String, Object> getAdditionalParam() {
        if (this.additionalParam == null) {
            this.additionalParam = Maps.newHashMap();
        }
        return this.additionalParam;
    }

    public String getSelectColumns() {
        if (this.tableInfo != null) {
            return this.tableInfo.getSelectColumns();
        }
        return "";
    }

    public String getTableName() {
        if (this.tableInfo != null) {
            return this.tableInfo.getTableName();
        }
        return "";
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public List<String> parseWhereLogic(Object whereLogic) {
        return MybatisWhereLogicHelper.parseWhereLogic(this.configuration.getGlobalAssistant(), whereLogic, this.getAdditionalParam());
    }

    public String formatCollection2ParameterMappings(String itemName, Collection<?> typeParams) {
        return MybatisSqlUtils.formatCollection2ParameterMappings("", "", itemName, typeParams, this.getAdditionalParam());
    }

    public MetaObject newMetaObject(Object obj) {
        return this.configuration.newMetaObject(obj);
    }

    public MybatisProviderContext clone() {
        try {
            return (MybatisProviderContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

