/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.mapper.provider;

import com.econage.core.db.mybatis.adaptation.MybatisConfiguration;
import com.econage.core.db.mybatis.entity.TableInfo;
import com.econage.core.db.mybatis.mapper.provider.MybatisProviderContext;
import com.econage.core.db.mybatis.mapper.provider.ProviderSqlSourceUtils;
import com.econage.core.db.mybatis.util.MybatisMapUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.apache.ibatis.annotations.Lang;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.apache.ibatis.builder.annotation.ProviderMethodResolver;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.ParamNameResolver;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;

public class MybatisProviderSqlSource
implements SqlSource {
    private final MybatisConfiguration configuration;
    private final Class<?> providerType;
    private final LanguageDriver languageDriver;
    private final Method mapperMethod;
    private final Method providerMethod;
    private final String[] providerMethodArgumentNames;
    private final Class<?>[] providerMethodParameterTypes;
    private MybatisProviderContext providerContextTpl;
    private final Integer providerContextIndex;
    private static volatile Constructor<ProviderContext> PROVIDER_CONTEXT_CONSTRUCTOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ProviderContext createMybatisProviderContext(Class<?> mapperType, Method mapperMethod, String databaseId) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (PROVIDER_CONTEXT_CONSTRUCTOR != null) return PROVIDER_CONTEXT_CONSTRUCTOR.newInstance(mapperType, mapperMethod, databaseId);
        Class<ProviderContext> clazz = ProviderContext.class;
        synchronized (ProviderContext.class) {
            if (PROVIDER_CONTEXT_CONSTRUCTOR != null) return PROVIDER_CONTEXT_CONSTRUCTOR.newInstance(mapperType, mapperMethod, databaseId);
            Constructor providerContextConstructor = ProviderContext.class.getDeclaredConstructor(Class.class, Method.class, String.class);
            providerContextConstructor.setAccessible(true);
            PROVIDER_CONTEXT_CONSTRUCTOR = providerContextConstructor;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return PROVIDER_CONTEXT_CONSTRUCTOR.newInstance(mapperType, mapperMethod, databaseId);
        }
    }

    public MybatisProviderSqlSource(MybatisConfiguration configuration, Annotation provider, Class<?> mapperType, Method mapperMethod, TableInfo tableInfo) {
        String candidateProviderMethodName;
        Method candidateProviderMethod = null;
        try {
            this.configuration = configuration;
            this.mapperMethod = mapperMethod;
            Lang lang = mapperMethod == null ? null : mapperMethod.getAnnotation(Lang.class);
            this.languageDriver = configuration.getLanguageDriver(lang == null ? null : lang.value());
            this.providerType = this.getProviderType(provider, mapperMethod);
            candidateProviderMethodName = (String)provider.annotationType().getMethod("method", new Class[0]).invoke((Object)provider, new Object[0]);
            if (candidateProviderMethodName.length() == 0 && ProviderMethodResolver.class.isAssignableFrom(this.providerType)) {
                candidateProviderMethod = ((ProviderMethodResolver)this.providerType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).resolveMethod(MybatisProviderSqlSource.createMybatisProviderContext(mapperType, mapperMethod, configuration.getDatabaseId()));
            }
            if (candidateProviderMethod == null) {
                candidateProviderMethodName = candidateProviderMethodName.length() == 0 ? "provideSql" : candidateProviderMethodName;
                for (Method m : this.providerType.getMethods()) {
                    if (!candidateProviderMethodName.equals(m.getName()) || !CharSequence.class.isAssignableFrom(m.getReturnType())) continue;
                    if (candidateProviderMethod != null) {
                        throw new BuilderException("Error creating SqlSource for SqlProvider. Method '" + candidateProviderMethodName + "' is found multiple in SqlProvider '" + this.providerType.getName() + "'. Sql provider method can not overload.");
                    }
                    candidateProviderMethod = m;
                }
            }
        }
        catch (BuilderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuilderException("Error creating SqlSource for SqlProvider.  Cause: " + e, (Throwable)e);
        }
        if (candidateProviderMethod == null) {
            throw new BuilderException("Error creating SqlSource for SqlProvider. Method '" + candidateProviderMethodName + "' not found in SqlProvider '" + this.providerType.getName() + "'.");
        }
        this.providerMethod = candidateProviderMethod;
        this.providerMethodArgumentNames = new ParamNameResolver((Configuration)configuration, this.providerMethod).getNames();
        this.providerMethodParameterTypes = ProviderSqlSourceUtils.parseProviderMethodParameterTypes(this.providerMethod);
        this.providerContextTpl = new MybatisProviderContext(configuration, mapperType, mapperMethod, configuration.getDatabaseId(), tableInfo);
        Integer candidateProviderContextIndex = null;
        for (int i = 0; i < this.providerMethodParameterTypes.length; ++i) {
            Class<?> parameterType = this.providerMethodParameterTypes[i];
            if (parameterType != MybatisProviderContext.class) continue;
            if (candidateProviderContextIndex != null) {
                throw new BuilderException("Error creating SqlSource for SqlProvider. ProviderContext found multiple in SqlProvider method (" + this.providerType.getName() + "." + this.providerMethod.getName() + "). ProviderContext can not define multiple in SqlProvider method argument.");
            }
            candidateProviderContextIndex = i;
        }
        this.providerContextIndex = candidateProviderContextIndex;
    }

    public BoundSql getBoundSql(Object parameterObject) {
        MybatisProviderContext providerContext = this.providerContextTpl.clone();
        SqlSource sqlSource = this.createSqlSource(parameterObject, providerContext);
        BoundSql boundSql = sqlSource.getBoundSql(parameterObject);
        if (MybatisMapUtils.isNotEmpty(providerContext.getAdditionalParam())) {
            for (Map.Entry<String, Object> entry : providerContext.getAdditionalParam().entrySet()) {
                boundSql.setAdditionalParameter(entry.getKey(), entry.getValue());
            }
        }
        return boundSql;
    }

    private SqlSource createSqlSource(Object parameterObject, MybatisProviderContext providerContext) {
        try {
            String sql;
            if (parameterObject instanceof Map) {
                int bindParameterCount = this.providerMethodParameterTypes.length - (this.providerContextIndex == null ? 0 : 1);
                if (bindParameterCount == 1 && this.providerMethodParameterTypes[Integer.valueOf(0).equals(this.providerContextIndex) ? 1 : 0].isAssignableFrom(parameterObject.getClass())) {
                    sql = this.invokeProviderMethod(this.extractProviderMethodArguments(providerContext, parameterObject));
                } else {
                    Map params = (Map)parameterObject;
                    sql = this.invokeProviderMethod(this.extractProviderMethodArguments(providerContext, params, this.providerMethodArgumentNames));
                }
            } else if (this.providerMethodParameterTypes.length == 0) {
                sql = this.invokeProviderMethod(new Object[0]);
            } else if (this.providerMethodParameterTypes.length == 1) {
                sql = this.providerContextIndex == null ? this.invokeProviderMethod(parameterObject) : this.invokeProviderMethod(providerContext);
            } else if (this.providerMethodParameterTypes.length == 2) {
                sql = this.invokeProviderMethod(this.extractProviderMethodArguments(providerContext, parameterObject));
            } else {
                throw new BuilderException("Cannot invoke SqlProvider method '" + this.providerMethod + "' with specify parameter '" + (parameterObject == null ? null : parameterObject.getClass()) + "' because SqlProvider method arguments for '" + this.mapperMethod + "' is an invalid combination.");
            }
            Class parameterType = parameterObject == null ? Object.class : parameterObject.getClass();
            return this.languageDriver.createSqlSource((Configuration)this.configuration, sql, parameterType);
        }
        catch (BuilderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuilderException("Error invoking SqlProvider method '" + this.providerMethod + "' with specify parameter '" + (parameterObject == null ? null : parameterObject.getClass()) + "'.  Cause: " + this.extractRootCause(e), (Throwable)e);
        }
    }

    private Throwable extractRootCause(Exception e) {
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    private Object[] extractProviderMethodArguments(MybatisProviderContext providerContext, Object parameterObject) {
        if (this.providerContextIndex != null) {
            Object[] args = new Object[2];
            args[this.providerContextIndex.intValue() == 0 ? 1 : 0] = parameterObject;
            args[this.providerContextIndex.intValue()] = providerContext;
            return args;
        }
        return new Object[]{parameterObject};
    }

    private Object[] extractProviderMethodArguments(MybatisProviderContext providerContext, Map<String, Object> params, String[] argumentNames) {
        Object[] args = new Object[argumentNames.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.providerContextIndex != null && this.providerContextIndex == i ? providerContext : params.get(argumentNames[i]);
        }
        return args;
    }

    private String invokeProviderMethod(Object ... args) throws Exception {
        CharSequence sql;
        Object targetObject = null;
        if (!Modifier.isStatic(this.providerMethod.getModifiers())) {
            targetObject = this.providerType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return (sql = (CharSequence)this.providerMethod.invoke(targetObject, args)) != null ? sql.toString() : null;
    }

    private Class<?> getProviderType(Annotation providerAnnotation, Method mapperMethod) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class type = (Class)providerAnnotation.annotationType().getMethod("type", new Class[0]).invoke((Object)providerAnnotation, new Object[0]);
        Class value = (Class)providerAnnotation.annotationType().getMethod("value", new Class[0]).invoke((Object)providerAnnotation, new Object[0]);
        if (value == Void.TYPE && type == Void.TYPE) {
            throw new BuilderException("Please specify either 'value' or 'type' attribute of @" + providerAnnotation.annotationType().getSimpleName() + " at the '" + mapperMethod.toString() + "'.");
        }
        if (value != Void.TYPE && type != Void.TYPE && value != type) {
            throw new BuilderException("Cannot specify different class on 'value' and 'type' attribute of @" + providerAnnotation.annotationType().getSimpleName() + " at the '" + mapperMethod.toString() + "'.");
        }
        return value == Void.TYPE ? type : value;
    }
}

