/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.plugins.pagination;

import com.econage.core.db.mybatis.MybatisException;
import com.econage.core.db.mybatis.enums.DBType;
import com.econage.core.db.mybatis.plugins.pagination.PaginationContext;
import com.econage.core.db.mybatis.plugins.pagination.dialects.H2Dialect;
import com.econage.core.db.mybatis.plugins.pagination.dialects.HSQLDialect;
import com.econage.core.db.mybatis.plugins.pagination.dialects.IDialect;
import com.econage.core.db.mybatis.plugins.pagination.dialects.MySql8Dialect;
import com.econage.core.db.mybatis.plugins.pagination.dialects.MySqlDialect;
import com.econage.core.db.mybatis.plugins.pagination.dialects.OracleDialect;
import com.econage.core.db.mybatis.plugins.pagination.dialects.PostgreDialect;
import com.econage.core.db.mybatis.plugins.pagination.dialects.SQLiteDialect;
import com.econage.core.db.mybatis.util.MybatisStringUtils;

public class DialectFactory {
    public static String buildPaginationSql(PaginationContext paginationContext, String dialectClazz) throws Exception {
        IDialect dialect = DialectFactory.getDialect(paginationContext.getDbType(), dialectClazz);
        return dialect.buildPaginationSql(paginationContext);
    }

    /*
     * Unable to fully structure code
     */
    private static IDialect getDialect(DBType dbType, String dialectClazz) throws Exception {
        dialect = null;
        if (MybatisStringUtils.isNotEmpty(dialectClazz)) {
            try {
                clazz = Class.forName(dialectClazz);
                if (!IDialect.class.isAssignableFrom(clazz)) ** GOTO lbl12
                dialect = (IDialect)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new MybatisException("Class :" + dialectClazz + " is not found");
            }
        } else if (null != dbType) {
            dialect = DialectFactory.getDialectByDbType(dbType);
        }
lbl12:
        // 5 sources

        if (dialect == null) {
            throw new MybatisException("The value of the dialect property in mybatis configuration.xml is not defined.");
        }
        return dialect;
    }

    private static IDialect getDialectByDbType(DBType dbType) {
        IDialect dialect;
        switch (dbType) {
            case MYSQL8: {
                dialect = MySql8Dialect.INSTANCE;
                break;
            }
            case MYSQL: {
                dialect = MySqlDialect.INSTANCE;
                break;
            }
            case ORACLE: {
                dialect = OracleDialect.INSTANCE;
                break;
            }
            case H2: {
                dialect = H2Dialect.INSTANCE;
                break;
            }
            case POSTGRE: {
                dialect = PostgreDialect.INSTANCE;
                break;
            }
            case HSQL: {
                dialect = HSQLDialect.INSTANCE;
                break;
            }
            case SQLITE: {
                dialect = SQLiteDialect.INSTANCE;
                break;
            }
            default: {
                throw new MybatisException("The Database's Not Supported! DBType:" + (Object)((Object)dbType));
            }
        }
        return dialect;
    }
}

