/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.plugins.pagination;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import org.apache.ibatis.session.RowBounds;

public class Pagination
extends RowBounds
implements Serializable {
    private int paginationOffset;
    private int paginationLimit;
    private String[] sortName;
    private String[] sortOrder;

    public static Pagination newPagination() {
        return new Pagination();
    }

    public static Pagination newPaginationWithPageRows(int page, int rows) {
        return new Pagination().paginationLimit(rows).paginationOffset((page - 1) * rows);
    }

    private Pagination() {
    }

    public Pagination rowBounds(RowBounds rowBounds) {
        this.setPaginationLimit(rowBounds.getLimit());
        this.setPaginationOffset(rowBounds.getOffset());
        return this;
    }

    public Pagination paginationLimit(int rows) {
        this.setPaginationLimit(rows);
        return this;
    }

    public Pagination paginationOffset(int page) {
        this.setPaginationOffset(page);
        return this;
    }

    public Pagination sortName(String[] sort) {
        this.setSortName(sort);
        return this;
    }

    public Pagination sortOrder(String[] order) {
        this.setSortOrder(order);
        return this;
    }

    public int getPaginationOffset() {
        return this.paginationOffset;
    }

    public void setPaginationOffset(int paginationOffset) {
        this.paginationOffset = paginationOffset;
    }

    public int getPaginationLimit() {
        return this.paginationLimit;
    }

    public void setPaginationLimit(int paginationLimit) {
        this.paginationLimit = paginationLimit;
    }

    public String[] getSortName() {
        return this.sortName;
    }

    public void setSortName(String ... sortName) {
        this.sortName = sortName;
    }

    public String[] getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String ... sortOrder) {
        this.sortOrder = sortOrder;
    }

    public int getOffset() {
        return 0;
    }

    public int getLimit() {
        return Integer.MAX_VALUE;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("paginationOffset", this.paginationOffset).add("paginationLimit", this.paginationLimit).add("sort[]", (Object)this.sortName).add("order[]", (Object)this.sortOrder).toString();
    }
}

