/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.plugins.pagination;

import com.econage.core.db.mybatis.enums.DBType;
import com.econage.core.db.mybatis.plugins.pagination.Pagination;
import com.econage.core.db.mybatis.util.MybatisSqlUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class PaginationContext {
    private final String originalSql;
    private final Pagination pagination;
    private final DBType dbType;
    private List<Object> paginationParamBefore;
    private List<Object> paginationParamAfter;

    public PaginationContext(String originalSql, Pagination pagination, DBType dbType) {
        this.originalSql = originalSql;
        this.pagination = pagination;
        this.dbType = dbType;
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    public String getOrderColumn() {
        if (!this.isSortNumConsistent()) {
            throw new IllegalStateException("order and sort not inconsistent!");
        }
        Object[] sortArray = this.pagination.getSortName();
        Object[] orderArray = this.pagination.getSortOrder();
        if (ArrayUtils.isEmpty((Object[])sortArray)) {
            return "";
        }
        ArrayList sortColumnWithOrder = Lists.newArrayListWithCapacity((int)sortArray.length);
        int l = sortArray.length;
        for (int i = 0; i < l; ++i) {
            if (ArrayUtils.isNotEmpty((Object[])orderArray)) {
                sortColumnWithOrder.add((String)sortArray[i] + " " + (String)orderArray[i]);
                continue;
            }
            sortColumnWithOrder.add(sortArray[i]);
        }
        return MybatisSqlUtils.commaJoin(sortColumnWithOrder);
    }

    public int getLimit() {
        return this.pagination.getPaginationLimit();
    }

    public int getOffset() {
        return this.pagination.getPaginationOffset();
    }

    public boolean isSortNumConsistent() {
        return ArrayUtils.isEmpty((Object[])this.pagination.getSortName()) || ArrayUtils.isEmpty((Object[])this.pagination.getSortOrder()) || this.pagination.getSortName().length == this.pagination.getSortOrder().length;
    }

    public void addPaginationParamBefore(Object param) {
        if (this.paginationParamBefore == null) {
            this.paginationParamBefore = Lists.newArrayList();
        }
        this.paginationParamBefore.add(param);
    }

    public void addPaginationParamAfter(Object param) {
        if (this.paginationParamAfter == null) {
            this.paginationParamAfter = Lists.newArrayList();
        }
        this.paginationParamAfter.add(param);
    }

    public List<Object> getPaginationParamBefore() {
        return this.paginationParamBefore;
    }

    public List<Object> getPaginationParamAfter() {
        return this.paginationParamAfter;
    }

    public DBType getDbType() {
        return this.dbType;
    }

    public Pagination getPagination() {
        return this.pagination;
    }
}

