/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.plugins.pagination;

import com.econage.core.db.mybatis.MybatisException;
import com.econage.core.db.mybatis.adaptation.MybatisConfiguration;
import com.econage.core.db.mybatis.adaptation.MybatisGlobalAssistant;
import com.econage.core.db.mybatis.entity.TableInfo;
import com.econage.core.db.mybatis.enums.DBType;
import com.econage.core.db.mybatis.mapper.dyna.entity.DynaClass;
import com.econage.core.db.mybatis.plugins.pagination.DialectFactory;
import com.econage.core.db.mybatis.plugins.pagination.Pagination;
import com.econage.core.db.mybatis.plugins.pagination.PaginationContext;
import com.econage.core.db.mybatis.util.MybatisStringUtils;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class PaginationInterceptor
implements Interceptor {
    private static final Log logger = LogFactory.getLog(PaginationInterceptor.class);
    private String dialectClazz;
    private Field additionalParametersField;

    public Object intercept(Invocation invocation) throws Throwable {
        ParameterMapping parameterMapping;
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        Executor executor = (Executor)invocation.getTarget();
        if (!SqlCommandType.SELECT.equals((Object)mappedStatement.getSqlCommandType())) {
            return invocation.proceed();
        }
        if (rowBounds == null) {
            args[2] = RowBounds.DEFAULT;
            return invocation.proceed();
        }
        if (rowBounds == RowBounds.DEFAULT) {
            return invocation.proceed();
        }
        BoundSql boundSql = args.length == 4 ? mappedStatement.getBoundSql(parameter) : (BoundSql)args[5];
        Pagination pagination = rowBounds instanceof Pagination ? (Pagination)rowBounds : Pagination.newPagination().rowBounds(rowBounds);
        this.parsePaginationSortInfo(pagination, mappedStatement, parameter);
        PaginationContext paginationContext = new PaginationContext(boundSql.getSql(), pagination, this.getDbType(mappedStatement));
        String paginationSql = DialectFactory.buildPaginationSql(paginationContext, this.dialectClazz);
        ArrayList parameterMappings = Lists.newArrayList();
        Map<String, Object> additionalParamMap = this.getBoundSqlAdditionalParameter(boundSql);
        if (paginationContext.getPaginationParamBefore() != null) {
            for (Object object : paginationContext.getPaginationParamBefore()) {
                parameterMapping = this.getPaginationParameterMappingByObject(mappedStatement.getConfiguration(), object);
                parameterMappings.add(parameterMapping);
                additionalParamMap.put(parameterMapping.getProperty(), object);
            }
        }
        if (boundSql.getParameterMappings() != null) {
            parameterMappings.addAll(boundSql.getParameterMappings());
        }
        if (paginationContext.getPaginationParamAfter() != null) {
            for (Object object : paginationContext.getPaginationParamAfter()) {
                parameterMapping = this.getPaginationParameterMappingByObject(mappedStatement.getConfiguration(), object);
                parameterMappings.add(parameterMapping);
                additionalParamMap.put(parameterMapping.getProperty(), object);
            }
        }
        BoundSql paginationBoundSql = new BoundSql(mappedStatement.getConfiguration(), paginationSql, (List)parameterMappings, parameter);
        for (Map.Entry<String, Object> entry : additionalParamMap.entrySet()) {
            paginationBoundSql.setAdditionalParameter(entry.getKey(), entry.getValue());
        }
        CacheKey cacheKey = executor.createCacheKey(mappedStatement, parameter, (RowBounds)pagination, paginationBoundSql);
        return executor.query(mappedStatement, parameter, RowBounds.DEFAULT, resultHandler, cacheKey, paginationBoundSql);
    }

    private Map<String, Object> getBoundSqlAdditionalParameter(BoundSql boundSql) throws IllegalAccessException {
        return (Map)this.additionalParametersField.get(boundSql);
    }

    private ParameterMapping getPaginationParameterMappingByObject(Configuration configuration, Object paramObject) {
        ParameterMapping.Builder builder = new ParameterMapping.Builder(configuration, "pagination" + paramObject.hashCode(), paramObject.getClass());
        return builder.build();
    }

    private TableInfo detectTableInfo(MappedStatement mappedStatement, Object parameter) throws ClassNotFoundException {
        Class modelClass;
        String mappedStatementId;
        String mappedStatementNameSpace;
        Class mapperClass;
        TableInfo tableInfo = null;
        MybatisGlobalAssistant mybatisGlobalAssistant = ((MybatisConfiguration)mappedStatement.getConfiguration()).getGlobalAssistant();
        tableInfo = mybatisGlobalAssistant.saveAndGetTableInfoByMapper(mapperClass = Resources.classForName((String)(mappedStatementNameSpace = (mappedStatementId = mappedStatement.getId()).substring(0, mappedStatementId.lastIndexOf(".")))));
        if (tableInfo != null) {
            return tableInfo;
        }
        if (mappedStatement.getResultMaps() != null && mappedStatement.getResultMaps().size() > 0 && (tableInfo = mybatisGlobalAssistant.saveAndGetTableInfoByModel(modelClass = ((ResultMap)mappedStatement.getResultMaps().get(0)).getType())) != null) {
            return tableInfo;
        }
        return null;
    }

    private void parsePaginationSortInfo(Pagination pagination, MappedStatement mappedStatement, Object parameter) throws ClassNotFoundException {
        Map params;
        if (parameter instanceof Map && (params = (Map)parameter).containsKey("dynaCls")) {
            DynaClass dynaClazzObj = (DynaClass)params.get("dynaCls");
            if (ArrayUtils.isEmpty((Object[])pagination.getSortName())) {
                pagination.setSortName(dynaClazzObj.getIdColumn());
            }
            return;
        }
        this.parseByTableInfo(pagination, mappedStatement, parameter);
    }

    private void parseByTableInfo(Pagination pagination, MappedStatement mappedStatement, Object parameter) throws ClassNotFoundException {
        TableInfo tableInfo = this.detectTableInfo(mappedStatement, parameter);
        if (tableInfo == null) {
            return;
        }
        if (ArrayUtils.isEmpty((Object[])pagination.getSortName())) {
            pagination.setSortName(tableInfo.getKeyColumn());
            return;
        }
        String[] sortPropertyArray = pagination.getSortName();
        String[] sortColumnArray = new String[sortPropertyArray.length];
        for (String sorProperty : sortPropertyArray) {
            String sortColumn = tableInfo.getAutoMappingColumnByProperty(sorProperty);
            sortColumnArray[i] = MybatisStringUtils.isEmpty(sortColumn) ? sorProperty : sortColumn;
        }
        pagination.setSortName(sortColumnArray);
    }

    private DBType getDbType(MappedStatement mappedStatement) {
        MybatisConfiguration mybatisConfiguration = (MybatisConfiguration)mappedStatement.getConfiguration();
        return mybatisConfiguration.getGlobalAssistant().getDbType();
    }

    public PaginationInterceptor() {
        try {
            this.additionalParametersField = BoundSql.class.getDeclaredField("additionalParameters");
            this.additionalParametersField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new MybatisException(e);
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties prop) {
        String dialectClazz = prop.getProperty("dialectClazz");
        if (MybatisStringUtils.isNotEmpty(dialectClazz)) {
            this.dialectClazz = dialectClazz;
        }
    }

    public PaginationInterceptor setDialectClazz(String dialectClazz) {
        this.dialectClazz = dialectClazz;
        return this;
    }
}

