/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.plugins.pagination.dialects;

import com.econage.core.db.mybatis.plugins.pagination.PaginationContext;
import com.econage.core.db.mybatis.plugins.pagination.dialects.IDialect;
import com.econage.core.db.mybatis.util.MybatisStringUtils;

public class MySqlDialect
implements IDialect {
    public static final MySqlDialect INSTANCE = new MySqlDialect();

    @Override
    public String buildPaginationSql(PaginationContext paginationContext) {
        StringBuilder sqlBuilder = new StringBuilder(paginationContext.getOriginalSql());
        String orderStr = paginationContext.getOrderColumn();
        if (MybatisStringUtils.isNotEmpty(orderStr)) {
            sqlBuilder.append(" order by ").append(orderStr);
        }
        sqlBuilder.append(" limit ").append(paginationContext.getOffset()).append(",").append(paginationContext.getLimit());
        return sqlBuilder.toString();
    }
}

