/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.util;

import com.econage.core.db.mybatis.MybatisPackageInfo;
import com.econage.core.db.mybatis.mapper.BaseMapper;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.Reflection;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class MybatisClassUtils {
    private static final Log logger = LogFactory.getLog(MybatisClassUtils.class);
    private static final Set<Class<?>> ALL_PRIMITIVE_WRAPPER_TYPES = Primitives.allWrapperTypes();
    private static final Set<Class<?>> ALL_PRIMITIVE_TYPES = Primitives.allPrimitiveTypes();
    public static final String[] EXCLUDE_CLAZZ_PREFIX_4_MODEL_PARSE_STATIC_ARRAY = new String[]{"java", "javax", "jdk", Reflection.getPackageName(MybatisPackageInfo.class)};

    public static Class<?> extractModelClass(Class<?> mapperClass) {
        if (mapperClass == BaseMapper.class) {
            logger.warn(" Current Class is BaseMapper ");
            return null;
        }
        Type[] types = mapperClass.getGenericInterfaces();
        ParameterizedType target = null;
        for (Type type : types) {
            if (!(type instanceof ParameterizedType) || !BaseMapper.class.isAssignableFrom(mapperClass)) continue;
            target = (ParameterizedType)type;
            break;
        }
        return target == null ? null : (Class)target.getActualTypeArguments()[0];
    }

    public static boolean isProxy(Class<?> clazz) {
        if (clazz != null) {
            for (Class<?> cls : clazz.getInterfaces()) {
                String interfaceName = cls.getName();
                if (!interfaceName.equals("net.sf.cglib.proxy.Factory") && !interfaceName.equals("org.springframework.cglib.proxy.Factory") && !interfaceName.equals("javassist.util.proxy.ProxyObject") && !interfaceName.equals("org.apache.ibatis.javassist.util.proxy.ProxyObject")) continue;
                return true;
            }
        }
        return false;
    }

    public static Class<?> getUserClass(Class<?> clazz) {
        return MybatisClassUtils.isProxy(clazz) ? clazz.getSuperclass() : clazz;
    }

    public static Class<?> getUserClass(Object object) {
        Preconditions.checkNotNull((Object)object, (Object)"Error: Instance must not be null");
        return MybatisClassUtils.getUserClass(object.getClass());
    }

    public static Class<?> parseBaseMapperInterfaceInService(Class<?> mapperClsInService) {
        if (mapperClsInService == null || mapperClsInService == Object.class) {
            return null;
        }
        List allInterfaces = ClassUtils.getAllInterfaces(mapperClsInService);
        for (Class singleInterface : allInterfaces) {
            Class<?>[] parentInterfaceArray;
            for (Class<?> i : parentInterfaceArray = singleInterface.getInterfaces()) {
                if (i != BaseMapper.class) continue;
                return singleInterface;
            }
            if (singleInterface.getAnnotation(Mapper.class) == null) continue;
            return singleInterface;
        }
        return null;
    }

    public static boolean isPrimitivesWrapperType(Class<?> clazz) {
        return ALL_PRIMITIVE_WRAPPER_TYPES.contains(clazz);
    }

    public static boolean isPrimitivesType(Class<?> clazz) {
        return ALL_PRIMITIVE_TYPES.contains(clazz);
    }

    public static boolean excludeClazzPrefix4ModelParseStatic(Class<?> clazz) {
        String modelName = clazz.getName();
        for (String excludeClazzPrefix : EXCLUDE_CLAZZ_PREFIX_4_MODEL_PARSE_STATIC_ARRAY) {
            if (!modelName.startsWith(excludeClazzPrefix)) continue;
            return true;
        }
        return MybatisClassUtils.isPrimitivesType(clazz) || MybatisClassUtils.isPrimitivesWrapperType(clazz);
    }
}

