/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.util;

import com.econage.core.db.mybatis.util.MybatisCollectionUtils;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class MybatisReflectionKit {
    private static final Log logger = LogFactory.getLog(MybatisReflectionKit.class);

    public static Class getSuperClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn(String.format("Warn: %s's superclass not ParameterizedType", clazz.getSimpleName()));
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn(String.format("Warn: Index: %s, Size of %s's Parameterized Type: %s .", index, clazz.getSimpleName(), params.length));
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn(String.format("Warn: %s not set the actual class on superclass generic parameter", clazz.getSimpleName()));
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Map<String, Field> getFieldMap(Class<?> clazz) {
        List<Field> fieldList = MybatisReflectionKit.getFieldList(clazz);
        Map<String, Field> fieldMap = Collections.emptyMap();
        if (MybatisCollectionUtils.isNotEmpty(fieldList)) {
            fieldMap = new LinkedHashMap<String, Field>();
            for (Field field : fieldList) {
                fieldMap.put(field.getName(), field);
            }
        }
        return fieldMap;
    }

    public static List<Field> getFieldList(Class<?> clazz) {
        Field[] fields;
        if (null == clazz || Object.class == clazz) {
            return null;
        }
        LinkedList fieldList = Lists.newLinkedList();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            fieldList.add(field);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == null) {
            return fieldList;
        }
        if (superClass.equals(Object.class)) {
            return fieldList;
        }
        return MybatisReflectionKit.excludeOverrideSuperField(fieldList, MybatisReflectionKit.getFieldList(superClass));
    }

    public static List<Field> excludeOverrideSuperField(List<Field> fieldList, List<Field> superFieldList) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Field field : fieldList) {
            fieldMap.put(field.getName(), field);
        }
        for (Field superField : superFieldList) {
            if (null != fieldMap.get(superField.getName())) continue;
            fieldList.add(superField);
        }
        return fieldList;
    }
}

