/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.util;

import com.econage.core.db.mybatis.util.MybatisStringUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MybatisSqlUtils {
    public static final String STATIC_FALSE_WHERE_SQL = " 1<>1 ";
    public static final String STATIC_TRUE_WHERE_SQL = " 1=1 ";
    public static final String NEW_VERSION_STAMP_SUFFIX = "_new_stamp__";
    public static final String CURR_VERSION_STAMP_SUFFIX = "_curr_stamp__";
    public static final Joiner COMMA_JOINER = Joiner.on((String)",").skipNulls();
    protected static final Joiner WHERE_PART_JOINER = Joiner.on((String)" and ").skipNulls();

    public static String formatCollection2ParameterMappings(String item, Collection<?> typeParams, Map<String, Object> additionalMap) {
        return MybatisSqlUtils.formatCollection2ParameterMappings("", "", item, typeParams, additionalMap);
    }

    public static String formatCollection2ParameterMappings(String open, String close, final String item, Collection<?> typeParams, final Map<String, Object> additionalMap) {
        Preconditions.checkNotNull((Object)item, (Object)"item is null!");
        if (additionalMap == null) {
            throw new NullPointerException(" additional map is null!");
        }
        List parameterTokenList = typeParams.stream().map(new Function<Object, String>(){
            int count = 0;

            @Override
            public String apply(Object input) {
                String parameterToken = item + "_" + this.count;
                ++this.count;
                additionalMap.put(parameterToken, input);
                return "#{" + parameterToken + "}";
            }
        }).collect(Collectors.toList());
        StringBuilder tokens = new StringBuilder();
        if (MybatisStringUtils.isNotEmpty(open)) {
            tokens.append(open);
        }
        tokens.append(COMMA_JOINER.join(parameterTokenList));
        if (MybatisStringUtils.isNotEmpty(close)) {
            tokens.append(close);
        }
        return tokens.toString();
    }

    public static String commaJoin(Collection<String> stringCollection) {
        return COMMA_JOINER.join(stringCollection);
    }

    public static String commaJoin(String ... stringCollection) {
        return COMMA_JOINER.join((Object[])stringCollection);
    }

    public static String wherePartJoin(Collection<String> stringCollection) {
        return " " + WHERE_PART_JOINER.join(stringCollection) + " ";
    }

    public static String wherePartJoin(String prefix, Collection<String> stringCollection) {
        return (prefix != null ? prefix : "") + " " + WHERE_PART_JOINER.join(stringCollection) + " ";
    }

    public static boolean retBool(Integer result) {
        return null != result && result >= 1;
    }

    public static boolean delBool(Integer result) {
        return null != result && result >= 0;
    }

    public static int retCount(Integer result) {
        return null == result ? 0 : result;
    }

    public static String formatBoundParameter(String propertyNameInBoundSQL) {
        return "#{" + propertyNameInBoundSQL + "}";
    }
}

