/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.util;

import com.econage.core.db.mybatis.util.MybatisStringEscape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MybatisStringUtils {
    public static final String EMPTY = "";
    public static final String IS = "is";
    public static final String WHERE_LOGIC_COLLECTION_REPLACE = "_@[collectionHolder]";
    public static final String UNDERLINE_STR = "_";
    public static final char UNDERLINE = '_';
    public static final String PLACE_HOLDER = "{%s}";
    private static boolean separatorBeforeDigit = false;
    private static boolean separatorAfterDigit = true;

    private MybatisStringUtils() {
    }

    public static boolean isEmpty(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !MybatisStringUtils.isEmpty(cs);
    }

    public static String camelToUnderline(String param) {
        if (MybatisStringUtils.isEmpty(param)) {
            return EMPTY;
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String camelToUnderline(String prefix, String param, String suffix) {
        if (MybatisStringUtils.isEmpty(param)) {
            return EMPTY;
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len).append(prefix);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        sb.append(suffix);
        return sb.toString();
    }

    public static String underlineToCamel(String param) {
        if (MybatisStringUtils.isEmpty(param)) {
            return EMPTY;
        }
        String temp = param.toLowerCase();
        int len = temp.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = temp.charAt(i);
            if (c == '_') {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(temp.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String firstToLowerCase(String param) {
        if (MybatisStringUtils.isEmpty(param)) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder(param.length());
        sb.append(param.substring(0, 1).toLowerCase());
        sb.append(param.substring(1));
        return sb.toString();
    }

    public static boolean isUpperCase(String str) {
        return MybatisStringUtils.match("^[A-Z]+$", str);
    }

    public static boolean match(String regex, String str) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public static String sqlArgsFill(String content, Object ... args) {
        int length;
        if (MybatisStringUtils.isEmpty(content)) {
            return null;
        }
        if (args != null && (length = args.length) >= 1) {
            for (int i = 0; i < length; ++i) {
                content = content.replace(String.format(PLACE_HOLDER, i), MybatisStringUtils.sqlParam(args[i]));
            }
        }
        return content;
    }

    public static String sqlParam(Object obj) {
        String repStr = obj instanceof Collection ? MybatisStringUtils.quotaMarkList((Collection)obj) : MybatisStringUtils.quotaMark(obj);
        return repStr;
    }

    public static String quotaMark(Object obj) {
        String srcStr = String.valueOf(obj);
        if (obj instanceof CharSequence) {
            return MybatisStringEscape.escapeString(srcStr);
        }
        return srcStr;
    }

    public static String quotaMarkList(Collection<?> coll) {
        StringBuilder sqlBuild = new StringBuilder();
        sqlBuild.append("(");
        int size = coll.size();
        int i = 0;
        Iterator<?> iterator = coll.iterator();
        while (iterator.hasNext()) {
            String tempVal = MybatisStringUtils.quotaMark(iterator.next());
            sqlBuild.append(tempVal);
            if (i + 1 < size) {
                sqlBuild.append(",");
            }
            ++i;
        }
        sqlBuild.append(")");
        return sqlBuild.toString();
    }

    public static String concatCapitalize(String concatStr, String str) {
        int strLen;
        if (MybatisStringUtils.isEmpty(concatStr)) {
            concatStr = EMPTY;
        }
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isTitleCase(firstChar)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(strLen);
        sb.append(concatStr);
        sb.append(Character.toTitleCase(firstChar));
        sb.append(str.substring(1));
        return sb.toString();
    }

    public static String capitalize(String str) {
        return MybatisStringUtils.concatCapitalize(null, str);
    }

    public static boolean checkValNotNull(Object object) {
        if (object instanceof CharSequence) {
            return MybatisStringUtils.isNotEmpty((CharSequence)object);
        }
        return object != null;
    }

    public static boolean checkValNull(Object object) {
        return !MybatisStringUtils.checkValNotNull(object);
    }

    public static boolean containsUpperCase(String word) {
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCapitalMode(String word) {
        return null != word && word.matches("^[0-9A-Z/_]+$");
    }

    public static boolean endsWith(String str, String suffix) {
        return MybatisStringUtils.endsWith(str, suffix, false);
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return MybatisStringUtils.endsWith(str, suffix, true);
    }

    private static boolean endsWith(String str, String suffix, boolean ignoreCase) {
        if (str == null || suffix == null) {
            return str == null && suffix == null;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return str.regionMatches(ignoreCase, strOffset, suffix, 0, suffix.length());
    }

    public static String[] split(String str, String separatorChars) {
        List<String> strings = MybatisStringUtils.splitWorker(str, separatorChars, -1, false);
        return strings.toArray(new String[strings.size()]);
    }

    public static List<String> splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list;
    }

    public static Boolean isCharSequence(Class<?> cls) {
        return cls != null && CharSequence.class.isAssignableFrom(cls);
    }

    public static String removeIsPrefixIfBoolean(String propertyName, Class<?> propertyType) {
        if (MybatisStringUtils.isBoolean(propertyType).booleanValue() && propertyName.startsWith(IS)) {
            String property = propertyName.replaceFirst(IS, EMPTY);
            if (MybatisStringUtils.isEmpty(property)) {
                return propertyName;
            }
            String firstCharToLowerStr = MybatisStringUtils.firstCharToLower(property);
            return property.equals(firstCharToLowerStr) ? propertyName : firstCharToLowerStr;
        }
        return propertyName;
    }

    public static Boolean isBoolean(Class<?> propertyCls) {
        return propertyCls != null && (Boolean.TYPE.isAssignableFrom(propertyCls) || Boolean.class.isAssignableFrom(propertyCls));
    }

    public static String firstCharToLower(String rawString) {
        return MybatisStringUtils.prefixToLower(rawString, 1);
    }

    public static String prefixToLower(String rawString, int index) {
        String beforeChar = rawString.substring(0, index).toLowerCase();
        String afterChar = rawString.substring(index, rawString.length());
        return beforeChar + afterChar;
    }

    public static String removePrefixAfterPrefixToLower(String rawString, int index) {
        return MybatisStringUtils.prefixToLower(rawString.substring(index, rawString.length()), 1);
    }

    public static String camelToHyphen(String input) {
        return MybatisStringUtils.wordsToHyphenCase(MybatisStringUtils.wordsAndHyphenAndCamelToConstantCase(input));
    }

    private static String wordsAndHyphenAndCamelToConstantCase(String input) {
        boolean betweenUpperCases = false;
        boolean containsLowerCase = MybatisStringUtils.containsLowerCase(input);
        StringBuilder buf = new StringBuilder();
        char previousChar = ' ';
        char[] chars = input.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            boolean isNotUnderscore;
            char c = chars[i];
            boolean isUpperCaseAndPreviousIsUpperCase = Character.isUpperCase(previousChar) && Character.isUpperCase(c);
            boolean isUpperCaseAndPreviousIsLowerCase = Character.isLowerCase(previousChar) && Character.isUpperCase(c);
            boolean previousIsWhitespace = Character.isWhitespace(previousChar);
            boolean lastOneIsNotUnderscore = buf.length() > 0 && buf.charAt(buf.length() - 1) != '_';
            boolean bl = isNotUnderscore = c != '_';
            if (lastOneIsNotUnderscore && (isUpperCaseAndPreviousIsLowerCase || previousIsWhitespace || betweenUpperCases && containsLowerCase && isUpperCaseAndPreviousIsUpperCase)) {
                buf.append(UNDERLINE_STR);
            } else if (separatorAfterDigit && Character.isDigit(previousChar) && Character.isLetter(c) || separatorBeforeDigit && Character.isDigit(c) && Character.isLetter(previousChar)) {
                buf.append('_');
            }
            if (MybatisStringUtils.shouldReplace(c) && lastOneIsNotUnderscore) {
                buf.append('_');
            } else if (!Character.isWhitespace(c) && (isNotUnderscore || lastOneIsNotUnderscore)) {
                buf.append(Character.toUpperCase(c));
            }
            previousChar = c;
        }
        if (Character.isWhitespace(previousChar)) {
            buf.append(UNDERLINE_STR);
        }
        return buf.toString();
    }

    public static boolean containsLowerCase(String s) {
        for (char c : s.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldReplace(char c) {
        return c == '.' || c == '_' || c == '-';
    }

    private static String wordsToHyphenCase(String s) {
        StringBuilder buf = new StringBuilder();
        char lastChar = 'a';
        for (char c : s.toCharArray()) {
            if (Character.isWhitespace(lastChar) && !Character.isWhitespace(c) && '-' != c && buf.length() > 0 && buf.charAt(buf.length() - 1) != '-') {
                buf.append("-");
            }
            if ('_' == c) {
                buf.append('-');
            } else if ('.' == c) {
                buf.append('-');
            } else if (!Character.isWhitespace(c)) {
                buf.append(Character.toLowerCase(c));
            }
            lastChar = c;
        }
        if (Character.isWhitespace(lastChar)) {
            buf.append("-");
        }
        return buf.toString();
    }
}

