/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.util;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class MybatisSystemClock {
    private final long period;
    private final AtomicLong now;

    private MybatisSystemClock(long period) {
        this.period = period;
        this.now = new AtomicLong(System.currentTimeMillis());
        this.scheduleClockUpdating();
    }

    private static MybatisSystemClock instance() {
        return InstanceHolder.INSTANCE;
    }

    public static long now() {
        return MybatisSystemClock.instance().currentTimeMillis();
    }

    public static String nowDateStr() {
        return new Timestamp(MybatisSystemClock.instance().currentTimeMillis()).toString();
    }

    public static Date nowDate() {
        return new Date(MybatisSystemClock.instance().currentTimeMillis());
    }

    public static Instant nowInstant() {
        return Instant.ofEpochMilli(MybatisSystemClock.now());
    }

    private void scheduleClockUpdating() {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, "System Clock");
            thread.setDaemon(true);
            return thread;
        });
        scheduler.scheduleAtFixedRate(() -> this.now.set(System.currentTimeMillis()), this.period, this.period, TimeUnit.MILLISECONDS);
    }

    private long currentTimeMillis() {
        return this.now.get();
    }

    private static class InstanceHolder {
        public static final MybatisSystemClock INSTANCE = new MybatisSystemClock(1L);

        private InstanceHolder() {
        }
    }
}

