/*
 * Decompiled with CFR 0.152.
 */
package com.econage.core.db.mybatis.wherelogic;

import com.econage.core.db.mybatis.MybatisException;
import com.econage.core.db.mybatis.adaptation.MybatisGlobalAssistant;
import com.econage.core.db.mybatis.annotations.WhereLogic;
import com.econage.core.db.mybatis.annotations.WhereLogicField;
import com.econage.core.db.mybatis.util.MybatisClassUtils;
import com.econage.core.db.mybatis.util.MybatisCollectionUtils;
import com.econage.core.db.mybatis.util.MybatisReflectionKit;
import com.econage.core.db.mybatis.util.MybatisSqlUtils;
import com.econage.core.db.mybatis.util.MybatisStringUtils;
import com.econage.core.db.mybatis.wherelogic.TokenReplaceHandler;
import com.econage.core.db.mybatis.wherelogic.WhereLogicContext;
import com.econage.core.db.mybatis.wherelogic.WhereLogicFieldInfo;
import com.econage.core.db.mybatis.wherelogic.WhereLogicInfo;
import com.econage.core.db.mybatis.wherelogic.WhereLogicParser;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.TypeParameterResolver;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class MybatisWhereLogicHelper {
    private static final Log logger = LogFactory.getLog(MybatisWhereLogicHelper.class);
    private static Character ZERO_CHAR = Character.valueOf('\u0000');
    private static final GenericTokenParser WHERE_LOGIC_FIELD_TOKEN_PARSER = new GenericTokenParser("#{", "}", (TokenHandler)new TokenReplaceHandler("wl"));

    public static WhereLogicInfo parseWhereLogicInfo(MybatisGlobalAssistant globalAssistant, Class<?> whereLogicCls) {
        if (whereLogicCls == null || Primitives.allPrimitiveTypes().contains(whereLogicCls) || Primitives.isWrapperType(whereLogicCls) || whereLogicCls == String.class || whereLogicCls.getAnnotation(WhereLogic.class) == null) {
            return null;
        }
        WhereLogicInfo whereLogicInfo = new WhereLogicInfo();
        whereLogicInfo.setClassName(whereLogicCls.getName());
        for (Field field : MybatisWhereLogicHelper.getAllFields(globalAssistant, whereLogicCls)) {
            try {
                whereLogicInfo.putSearchFieldInfo(MybatisWhereLogicHelper.parseField(globalAssistant, field));
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new MybatisException(e);
            }
        }
        return whereLogicInfo;
    }

    public static List<String> parseWhereLogic(MybatisGlobalAssistant globalAssistant, Object whereLogicObj, Map<String, Object> additionMap) {
        if (whereLogicObj == null) {
            return Collections.emptyList();
        }
        WhereLogicInfo whereLogicInfo = globalAssistant.saveAndGetWhereLogic(whereLogicObj.getClass());
        if (whereLogicInfo == null) {
            return Collections.emptyList();
        }
        MetaObject whereLogicMetaObject = globalAssistant.getConfiguration().newMetaObject(whereLogicObj);
        ArrayList wherePart = Lists.newArrayListWithCapacity((int)whereLogicInfo.getFieldInfos().size());
        whereLogicInfo.getFieldInfos().forEach(whereLogicFieldInfo -> {
            String property = whereLogicFieldInfo.getProperty();
            Object propertyVal = whereLogicMetaObject.getValue(property);
            if (propertyVal == null) {
                return;
            }
            if (whereLogicFieldInfo.getWhereLogicParser() != null) {
                String parsedStr = whereLogicFieldInfo.getWhereLogicParser().parseWhereLogic(WhereLogicContext.newContext(additionMap, whereLogicObj));
                if (MybatisStringUtils.isNotEmpty(parsedStr)) {
                    wherePart.add(parsedStr);
                }
                return;
            }
            if (whereLogicFieldInfo.isPrimitiveType()) {
                if (whereLogicFieldInfo.isUsePrimitiveZero()) {
                    wherePart.add(whereLogicFieldInfo.getWhereLogic());
                } else if (!MybatisWhereLogicHelper.isZero(propertyVal)) {
                    wherePart.add(whereLogicFieldInfo.getWhereLogic());
                }
                return;
            }
            if (whereLogicFieldInfo.isCollectionType() || whereLogicFieldInfo.isArrayType()) {
                Collection collectionVal = whereLogicFieldInfo.isArrayType() ? MybatisWhereLogicHelper.convert2Collection(propertyVal) : (Collection)propertyVal;
                if (MybatisCollectionUtils.isEmpty(collectionVal)) {
                    return;
                }
                wherePart.add(StringUtils.replace((String)whereLogicFieldInfo.getWhereLogic(), (String)"_@[collectionHolder]", (String)MybatisSqlUtils.formatCollection2ParameterMappings(property, collectionVal, additionMap)));
                return;
            }
            if (CharSequence.class.isAssignableFrom(whereLogicFieldInfo.getType()) && StringUtils.isEmpty((CharSequence)((CharSequence)propertyVal))) {
                return;
            }
            wherePart.add(whereLogicFieldInfo.getWhereLogic());
            additionMap.put(property, propertyVal);
        });
        return wherePart;
    }

    private static boolean isZero(Object propertyVal) {
        return Objects.equals(NumberUtils.LONG_ZERO, propertyVal) || Objects.equals(NumberUtils.INTEGER_ZERO, propertyVal) || Objects.equals(NumberUtils.SHORT_ZERO, propertyVal) || Objects.equals(NumberUtils.BYTE_ZERO, propertyVal) || Objects.equals(NumberUtils.FLOAT_ZERO, propertyVal) || Objects.equals(NumberUtils.DOUBLE_ZERO, propertyVal) || Objects.equals(Boolean.FALSE, propertyVal) || Objects.equals(ZERO_CHAR, propertyVal);
    }

    private static Collection<?> convert2Collection(Object obj) {
        if (obj == null) {
            return Collections.EMPTY_LIST;
        }
        Class<?> objCls = obj.getClass();
        if (objCls == long[].class) {
            return Arrays.asList(ArrayUtils.toObject((long[])((long[])obj)));
        }
        if (objCls == int[].class) {
            return Arrays.asList(ArrayUtils.toObject((int[])((int[])obj)));
        }
        if (objCls == short[].class) {
            return Arrays.asList(ArrayUtils.toObject((short[])((short[])obj)));
        }
        if (objCls == byte[].class) {
            return Arrays.asList(ArrayUtils.toObject((byte[])((byte[])obj)));
        }
        if (objCls == float[].class) {
            return Arrays.asList(ArrayUtils.toObject((float[])((float[])obj)));
        }
        if (objCls == double[].class) {
            return Arrays.asList(ArrayUtils.toObject((double[])((double[])obj)));
        }
        if (objCls == boolean[].class) {
            return Arrays.asList(ArrayUtils.toObject((boolean[])((boolean[])obj)));
        }
        if (objCls == char[].class) {
            return Arrays.asList(ArrayUtils.toObject((char[])((char[])obj)));
        }
        return Arrays.asList((Object[])obj);
    }

    private static WhereLogicFieldInfo parseField(MybatisGlobalAssistant globalAssistant, Field field) throws IllegalAccessException, InstantiationException {
        WhereLogicFieldInfo whereLogicFieldInfo = new WhereLogicFieldInfo();
        whereLogicFieldInfo.setType(field.getType());
        whereLogicFieldInfo.setProperty(field.getName());
        if (Collection.class.isAssignableFrom(field.getType())) {
            whereLogicFieldInfo.setCollectionType(true);
        } else if (field.getType().isArray()) {
            whereLogicFieldInfo.setArrayType(true);
        } else {
            whereLogicFieldInfo.setPrimitiveType(Primitives.allPrimitiveTypes().contains(field.getType()));
        }
        WhereLogicField whereLogicField = field.getAnnotation(WhereLogicField.class);
        if (whereLogicField != null) {
            whereLogicFieldInfo.setUsePrimitiveZero(whereLogicField.usePrimitiveZero());
        }
        if (whereLogicField != null && StringUtils.isNotEmpty((CharSequence)whereLogicField.column())) {
            whereLogicFieldInfo.setColumn(whereLogicField.column());
        } else {
            whereLogicFieldInfo.setColumn(globalAssistant.formatColumn(field.getName()));
        }
        if (whereLogicField != null && StringUtils.isNotEmpty((CharSequence)whereLogicField.wherePart())) {
            whereLogicFieldInfo.setWhereLogic(WHERE_LOGIC_FIELD_TOKEN_PARSER.parse(whereLogicField.wherePart()));
        } else if (whereLogicFieldInfo.isCollectionType() || whereLogicFieldInfo.isArrayType()) {
            whereLogicFieldInfo.setWhereLogic(whereLogicFieldInfo.getColumn() + " in ( " + "_@[collectionHolder]" + " )");
        } else {
            whereLogicFieldInfo.setWhereLogic(whereLogicFieldInfo.getColumn() + "=#{" + "wl" + "." + StringUtils.trim((String)whereLogicFieldInfo.getProperty()) + "}");
        }
        if (whereLogicField != null && whereLogicField.parser() != WhereLogicParser.class) {
            whereLogicFieldInfo.setWhereLogicParser(whereLogicField.parser().newInstance());
        }
        return whereLogicFieldInfo;
    }

    private static List<Field> getAllFields(MybatisGlobalAssistant globalAssistant, Class<?> cls) {
        TypeHandlerRegistry typeHandlerRegistry = globalAssistant.getConfiguration().getTypeHandlerRegistry();
        List<Field> rawFieldList = MybatisReflectionKit.getFieldList(MybatisClassUtils.getUserClass(cls));
        if (MybatisCollectionUtils.isEmpty(rawFieldList)) {
            return Collections.emptyList();
        }
        ArrayList<Field> validFieldList = new ArrayList<Field>(rawFieldList.size());
        for (Field field : rawFieldList) {
            WhereLogicField whereLogicField = field.getAnnotation(WhereLogicField.class);
            if (whereLogicField != null && !whereLogicField.enable() || !typeHandlerRegistry.hasTypeHandler(MybatisWhereLogicHelper.parseWhereFieldComponentType(field, cls))) continue;
            validFieldList.add(field);
        }
        return validFieldList;
    }

    private static Class<?> parseWhereFieldComponentType(Field field, Class<?> cls) {
        Class<?> returnType = field.getType();
        Type resolvedReturnType = TypeParameterResolver.resolveFieldType((Field)field, cls);
        if (resolvedReturnType instanceof Class) {
            returnType = (Class<?>)resolvedReturnType;
            if (returnType.isArray()) {
                returnType = returnType.getComponentType();
            }
        } else if (resolvedReturnType instanceof ParameterizedType) {
            Type[] actualTypeArguments;
            Type returnTypeParameter;
            ParameterizedType parameterizedType = (ParameterizedType)resolvedReturnType;
            Class rawType = (Class)parameterizedType.getRawType();
            if (Collection.class.isAssignableFrom(rawType)) {
                Type[] actualTypeArguments2 = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments2 != null && actualTypeArguments2.length == 1) {
                    Type returnTypeParameter2 = actualTypeArguments2[0];
                    if (returnTypeParameter2 instanceof Class) {
                        returnType = (Class)returnTypeParameter2;
                    } else if (returnTypeParameter2 instanceof ParameterizedType) {
                        returnType = (Class)((ParameterizedType)returnTypeParameter2).getRawType();
                    } else if (returnTypeParameter2 instanceof GenericArrayType) {
                        Class componentType = (Class)((GenericArrayType)returnTypeParameter2).getGenericComponentType();
                        returnType = Array.newInstance(componentType, 0).getClass();
                    }
                }
            } else if (Optional.class.equals((Object)rawType) && (returnTypeParameter = (actualTypeArguments = parameterizedType.getActualTypeArguments())[0]) instanceof Class) {
                returnType = (Class<?>)returnTypeParameter;
            }
        }
        return returnType;
    }
}

