/**
 *    Copyright 2017-2018 the original author or authors.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package com.econage.core.db.mybatis.annotations;

import com.econage.core.db.mybatis.enums.FieldStrategy;
import com.econage.core.db.mybatis.enums.FieldStrategy;

import java.lang.annotation.*;

/**
 * <p>
 * 表字段标识
 * </p>
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@Documented
@Inherited
public @interface TableField {

    /**
     * <p>
     * 字段值（驼峰命名方式，该值可无）
     * </p>
     */
    String value() default "";

    /**
     * <p>
     * 当该Field为类对象时, 可使用#{对象.属性}来映射到数据表.
     * </p>
     * <p>
     * 支持：@TableField(el = "role, jdbcType=BIGINT)<br>
     * 支持：@TableField(el = "role, typeHandler=*** ")
     * </p>
     */
    String el() default "";

    /**
     * <p>
     * 是否为数据库表字段
     * </p>
     * <p>
     * 默认 true 存在，false 不存在
     * </p>
     */
    boolean exist() default true;

    /*
     * 默认插入方法中是否生效
     * */
    boolean defaultInsert() default true;

    /*
     * 默认更新方法中是否生效
     * */
    boolean defaultUpdate() default true;

    /**
     * <p>
     * 字段验证策略
     * </p>
     * <p>
     * 默认 非 null 判断
     * </p>
     */
    FieldStrategy strategy() default FieldStrategy.NOT_NULL;

    /*
    * 是否外键字段
    * */
    boolean isFk() default false;

    /*
    * 是否乐观锁字段
    * */
    boolean isVersion() default false;

    /*
    * 是否树形关系父节点id列
    * */
    boolean isTreeParentLink() default false;

    /*
     * 是否树形关系邻居排序列
     * */
    boolean isTreeSiblingOrder() default false;

}
