/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.actions;

import com.greenpepper.confluence.actions.AbstractGreenPepperAction;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.domain.Execution;
import com.greenpepper.server.domain.Project;
import com.greenpepper.server.domain.Reference;
import com.greenpepper.server.domain.Repository;
import com.greenpepper.server.domain.Requirement;
import com.greenpepper.server.domain.Runner;
import com.greenpepper.server.domain.Specification;
import com.greenpepper.server.domain.SystemUnderTest;
import com.greenpepper.util.ExceptionUtils;
import com.greenpepper.util.HtmlUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class SpecificationAction
extends AbstractGreenPepperAction {
    protected Specification specification;
    private List<Reference> references;
    private List<Repository> repositories;
    private List<SystemUnderTest> projectSystemUnderTests;
    private String selectedSystemUnderTestInfo;
    private Execution execution;
    private String requirementName;
    private String sutName;
    private String sutProjectName;
    private String repositoryUid;
    private String sections;
    private boolean isMain;
    private boolean isSutEditable;
    protected boolean implemented;

    public String loadSpecification() {
        block2: {
            try {
                this.specification = this.gpUtil.getSpecification(this.spaceKey, this.getPage().getTitle());
            }
            catch (GreenPepperServerException e) {
                if (e.getId().equals("greenpepper.server.specificationnotfound")) break block2;
                this.addActionError(e.getId());
            }
        }
        return "success";
    }

    public String updateSelectedSystemUndertTest() {
        this.gpUtil.saveSelectedSystemUnderTestInfo(this.page, this.selectedSystemUnderTestInfo);
        return "success";
    }

    public String getSystemUndertTestSelection() {
        try {
            this.specification = this.gpUtil.getSpecification(this.spaceKey, this.getPage().getTitle());
            this.projectSystemUnderTests = this.gpUtil.getSystemsUnderTests(this.spaceKey);
        }
        catch (GreenPepperServerException e) {
            this.projectSystemUnderTests = new ArrayList<SystemUnderTest>();
            this.addActionError(e.getId());
        }
        return "success";
    }

    public String addSystemUnderTest() {
        try {
            SystemUnderTest sut = SystemUnderTest.newInstance((String)this.sutName);
            sut.setProject(Project.newInstance((String)this.sutProjectName));
            sut.setRunner(Runner.newInstance((String)""));
            Specification specification = Specification.newInstance((String)this.getPage().getTitle());
            specification.setRepository(this.gpUtil.getHomeRepository(this.spaceKey));
            this.gpUtil.getGPServerService().addSpecificationSystemUnderTest(sut, specification);
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return this.getSystemUndertTestSelection();
    }

    public String removeSystemUnderTest() {
        try {
            SystemUnderTest sut = SystemUnderTest.newInstance((String)this.sutName);
            sut.setProject(Project.newInstance((String)this.sutProjectName));
            sut.setRunner(Runner.newInstance((String)""));
            Specification specification = Specification.newInstance((String)this.getPage().getTitle());
            specification.setRepository(this.gpUtil.getHomeRepository(this.spaceKey));
            this.gpUtil.getGPServerService().removeSpecificationSystemUnderTest(sut, specification);
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return this.getSystemUndertTestSelection();
    }

    public String run() {
        String locale = this.getLocale().getLanguage();
        SystemUnderTest sut = SystemUnderTest.newInstance((String)this.sutName);
        sut.setProject(Project.newInstance((String)this.sutProjectName));
        sut.setRunner(Runner.newInstance((String)""));
        Specification spec = Specification.newInstance((String)this.getPage().getTitle());
        try {
            spec.setRepository(this.gpUtil.getHomeRepository(this.spaceKey));
            this.execution = this.gpUtil.getGPServerService().runSpecification(sut, spec, this.implemented, locale);
        }
        catch (GreenPepperServerException e) {
            this.execution = Execution.error((Specification)spec, (SystemUnderTest)sut, null, (String)e.getId());
        }
        catch (Exception e) {
            this.execution = Execution.error((Specification)spec, (SystemUnderTest)sut, null, (String)ExceptionUtils.stackTrace((Throwable)e, (String)"<br>", (int)15));
        }
        return "success";
    }

    public String retrieveReferenceList() {
        try {
            this.references = this.gpUtil.getReferences(this.spaceKey, this.getPage().getTitle());
            if (this.isEditMode) {
                this.repositories = this.gpUtil.getRepositories(this.spaceKey);
                if (this.repositories.isEmpty()) {
                    throw new GreenPepperServerException("greenpepper.server.repositoriesnotfound", "");
                }
                this.projectSystemUnderTests = this.gpUtil.getSystemsUnderTests(this.spaceKey);
                if (this.projectSystemUnderTests.isEmpty()) {
                    throw new GreenPepperServerException("greenpepper.server.sutsnotfound", "");
                }
            }
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
            this.isEditMode = false;
        }
        return "success";
    }

    public String addReference() {
        try {
            this.gpUtil.getGPServerService().createReference(this.instanceOfReference());
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return this.retrieveReferenceList();
    }

    public String removeReference() {
        this.isEditMode = true;
        try {
            this.gpUtil.getGPServerService().removeReference(this.instanceOfReference());
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return this.retrieveReferenceList();
    }

    public Specification getSpecification() {
        return this.specification;
    }

    public List<Repository> getRepositories() {
        return this.repositories;
    }

    public List<SystemUnderTest> getProjectSystemUnderTests() {
        return this.projectSystemUnderTests;
    }

    public Set<SystemUnderTest> getSpecificationSystemUnderTests() {
        if (this.specification == null) {
            return new HashSet<SystemUnderTest>();
        }
        return this.specification.getTargetedSystemUnderTests();
    }

    public boolean getIsSutEditable() {
        return this.isSutEditable;
    }

    public void setIsSutEditable(boolean isSutEditable) {
        this.isSutEditable = isSutEditable;
    }

    public boolean getImplemented() {
        return this.implemented;
    }

    public void setImplemented(boolean implemented) {
        this.implemented = implemented;
    }

    public String getRequirementName() {
        return this.requirementName;
    }

    public void setRequirementName(String requirementName) {
        this.requirementName = requirementName;
    }

    public void setSutInfo(String sutInfo) {
        StringTokenizer stk = new StringTokenizer(sutInfo, "@");
        this.sutProjectName = stk.nextToken();
        this.sutName = stk.nextToken();
    }

    public void setSutName(String sutName) {
        this.sutName = sutName;
    }

    public void setSutProjectName(String sutProjectName) {
        this.sutProjectName = sutProjectName;
    }

    public void setRepositoryUid(String repositoryUid) {
        this.repositoryUid = repositoryUid;
    }

    public void setSections(String sections) {
        this.sections = sections.trim();
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public SystemUnderTest getSelectedSystemUnderTest() {
        return this.gpUtil.getSelectedSystemUnderTest(this.page);
    }

    public boolean getIsExecutable() {
        return this.specification != null;
    }

    public Execution getExecution() {
        return this.execution;
    }

    public String getSelectedSystemUnderTestInfo() {
        if (this.selectedSystemUnderTestInfo != null) {
            return this.selectedSystemUnderTestInfo;
        }
        this.selectedSystemUnderTestInfo = this.gpUtil.getSelectedSystemUnderTestInfo(this.page);
        return this.selectedSystemUnderTestInfo;
    }

    public void setSelectedSystemUnderTestInfo(String selectedSystemUnderTestInfo) {
        this.selectedSystemUnderTestInfo = selectedSystemUnderTestInfo;
    }

    public boolean getIsMain() {
        return this.isMain;
    }

    public void setIsMain(boolean isMain) {
        this.isMain = isMain;
    }

    public String getRenderedResults() {
        String results = this.execution.getResults();
        if (results != null) {
            results = results.replaceAll("greenpepper-manage-not-rendered", "greenpepper-manage");
            results = results.replaceAll("greenpepper-hierarchy-not-rendered", "greenpepper-hierarchy");
            results = results.replaceAll("greenpepper-children-not-rendered", "greenpepper-children");
            results = results.replaceAll("greenpepper-labels-not-rendered", "greenpepper-labels");
            results = results.replaceAll("greenpepper-group-not-rendered", "greenpepper-group");
            results = results.replaceAll("Unknown macro:", "");
            return HtmlUtil.cleanUpResults((String)results);
        }
        return null;
    }

    public boolean isInSpecificationSelection(SystemUnderTest systemUnderTest) {
        return this.gpUtil.isInSutList(systemUnderTest, this.specification.getTargetedSystemUnderTests());
    }

    private Reference instanceOfReference() throws GreenPepperServerException {
        SystemUnderTest sut = SystemUnderTest.newInstance((String)this.sutName);
        sut.setProject(Project.newInstance((String)this.sutProjectName));
        Specification specification = Specification.newInstance((String)this.getPage().getTitle());
        specification.setRepository(this.gpUtil.getHomeRepository(this.spaceKey));
        Requirement requirement = Requirement.newInstance((String)this.requirementName);
        requirement.setRepository(Repository.newInstance((String)this.repositoryUid));
        return Reference.newInstance((Requirement)requirement, (Specification)specification, (SystemUnderTest)sut, (String)this.sections);
    }

    public int getNextFieldId() {
        return this.getFieldId() + 1;
    }
}

