/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.actions.execution;

import com.atlassian.confluence.pages.Page;
import com.atlassian.renderer.RenderContext;
import com.greenpepper.confluence.actions.execution.ChildrenExecutionAction;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.domain.Specification;
import com.greenpepper.server.domain.SystemUnderTest;
import java.util.LinkedList;
import java.util.List;

public class HeaderExecutionAction
extends ChildrenExecutionAction {
    private Boolean hasChildren;
    private Boolean doExecuteChildren;
    private boolean pepperize;
    private boolean retrieveBody;

    public String loadHeader() {
        this.retrieveReferenceList();
        this.loadSpecification();
        return "success";
    }

    public String setAsImplemented() {
        this.gpUtil.saveImplementedVersion(this.getPage(), this.getPage().getVersion());
        return this.loadHeader();
    }

    public String revert() {
        this.gpUtil.revertImplementation(this.getPage());
        return this.loadHeader();
    }

    public String greenPepperize() {
        if (this.pepperize) {
            try {
                Specification spec = Specification.newInstance((String)this.getPage().getTitle());
                spec.setRepository(this.gpUtil.getHomeRepository(this.spaceKey));
                this.specification = this.gpUtil.getGPServerService().createSpecification(spec);
                return this.loadHeader();
            }
            catch (GreenPepperServerException e) {
                this.addActionError(e.getId());
            }
        } else {
            try {
                Specification spec = Specification.newInstance((String)this.getPage().getTitle());
                spec.setRepository(this.gpUtil.getHomeRepository(this.spaceKey));
                this.gpUtil.getGPServerService().removeSpecification(spec);
                this.gpUtil.saveExecuteChildren(this.page, false);
                this.gpUtil.saveImplementedVersion(this.getPage(), null);
                this.gpUtil.savePreviousImplementedVersion(this.getPage(), null);
                this.specification = null;
            }
            catch (GreenPepperServerException e) {
                this.addActionError(e.getId());
                return this.loadHeader();
            }
        }
        return "success";
    }

    public String updateExecuteChildren() {
        this.gpUtil.saveExecuteChildren(this.page, this.doExecuteChildren);
        return "success";
    }

    @Override
    public List<SystemUnderTest> getForcedSystemUnderTests() {
        return null;
    }

    public boolean getCanBeImplemented() {
        return this.gpUtil.canBeImplemented(this.getPage());
    }

    public boolean getCanBeReverted() {
        return this.getPreviousImplementedVersion() != null;
    }

    public Integer getImplementedVersion() {
        return this.gpUtil.getImplementedVersion(this.getPage());
    }

    public Integer getPreviousImplementedVersion() {
        return this.gpUtil.getPreviousImplementedVersion(this.getPage());
    }

    public String getRenderedContent() {
        String content;
        try {
            content = this.implemented ? this.gpUtil.getImplementedContent(this.getPage()) : this.getPage().getContent();
        }
        catch (GreenPepperServerException e) {
            content = "";
        }
        return this.gpUtil.getWikiStyleRenderer().convertWikiToXHtml((RenderContext)this.getPage().toPageContext(), content);
    }

    @Override
    public LinkedList<Page> getExecutableList() {
        if (!this.getDoExecuteChildren()) {
            return new LinkedList<Page>();
        }
        return super.getExecutableList();
    }

    public boolean getHasChildren() {
        if (this.hasChildren != null) {
            return this.hasChildren;
        }
        this.hasChildren = !this.implemented && !super.getExecutableList().isEmpty();
        return this.hasChildren;
    }

    public boolean getDoExecuteChildren() {
        if (this.doExecuteChildren != null) {
            return this.doExecuteChildren;
        }
        this.doExecuteChildren = this.getHasChildren() && this.gpUtil.getExecuteChildren(this.page);
        return this.doExecuteChildren;
    }

    public void setDoExecuteChildren(boolean doExecuteChildren) {
        this.doExecuteChildren = doExecuteChildren;
    }

    @Override
    public String getExecutionUID() {
        return "HEADER";
    }

    @Override
    public boolean getIsSutEditable() {
        return true;
    }

    @Override
    public boolean getAllChildren() {
        return true;
    }

    public boolean getIsSelfIncluded() {
        return true;
    }

    public boolean isPepperize() {
        return this.pepperize;
    }

    public void setPepperize(boolean pepperize) {
        this.pepperize = pepperize;
    }

    public boolean getRetrieveBody() {
        return this.retrieveBody;
    }

    public void setRetrieveBody(boolean retrieveBody) {
        this.retrieveBody = retrieveBody;
    }

    public boolean isImplementationDue() {
        return this.gpUtil.isImplementationDue(this.getPage());
    }
}

