/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.actions.server;

import com.greenpepper.confluence.actions.server.GreenPepperServerAction;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.domain.Project;
import com.greenpepper.server.domain.Repository;
import com.greenpepper.server.domain.RepositoryType;
import com.greenpepper.server.domain.component.ContentType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class FileSystemRegistration
extends GreenPepperServerAction {
    private static RepositoryType FILE = RepositoryType.newInstance((String)"FILE");
    private List<Repository> fileRepositories;
    private Repository newRepository;
    private String repositoryUid;
    private String newName;
    private String newBaseTestUrl;
    private String newProjectName;
    private boolean editMode;
    private LinkedList<Project> projects;

    public String doGetFileSystemRegistration() {
        if (!this.isServerReady()) {
            this.addActionError("greenpepper.server.noconfiguration");
            return "success";
        }
        try {
            this.setFileRepositories(this.getService().getAllSpecificationRepositories());
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return "success";
    }

    public String doAddFileSystem() {
        try {
            this.setFileRepositories(this.getService().getAllSpecificationRepositories());
            if (!this.pathAlreadyExists()) {
                this.getNewRepository().setProject(Project.newInstance((String)this.newProjectName));
                this.newRepository.setType(FILE);
                this.newRepository.setName(this.newName);
                this.newRepository.setContentType(ContentType.TEST);
                this.newRepository.setBaseUrl(this.newBaseTestUrl);
                this.newRepository.setBaseRepositoryUrl(this.newBaseTestUrl);
                this.newRepository.setBaseTestUrl(this.newBaseTestUrl);
                this.getService().registerRepository(this.newRepository);
                this.newRepository = null;
            }
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return this.doGetFileSystemRegistration();
    }

    public String doRemoveFileSystem() {
        try {
            this.getService().removeRepository(this.repositoryUid);
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return this.doGetFileSystemRegistration();
    }

    public List<Repository> getFileRepositories() {
        if (this.fileRepositories != null) {
            try {
                this.setFileRepositories(this.getService().getAllSpecificationRepositories());
            }
            catch (GreenPepperServerException e) {
                this.addActionError(e.getId());
            }
        }
        return this.fileRepositories;
    }

    public void setFileRepositories(List<Repository> repositories) {
        this.fileRepositories = new ArrayList<Repository>();
        for (Repository repository : repositories) {
            if (!repository.getType().equals((Object)FILE)) continue;
            this.fileRepositories.add(repository);
        }
    }

    public String getRepositoryUid() {
        return this.repositoryUid;
    }

    public void setRepositoryUid(String repositoryUid) {
        this.repositoryUid = repositoryUid;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public String getNewBaseTestUrl() {
        return this.newBaseTestUrl;
    }

    public void setNewBaseTestUrl(String newBaseTestUrl) {
        if (!(newBaseTestUrl = newBaseTestUrl.trim()).endsWith("/")) {
            newBaseTestUrl = newBaseTestUrl + "/";
        }
        this.newBaseTestUrl = newBaseTestUrl;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName.trim();
    }

    @Override
    public String getProjectName() {
        return this.newProjectName;
    }

    @Override
    public void setProjectName(String projectName) {
        this.newProjectName = projectName;
    }

    public Repository getNewRepository() {
        if (this.newRepository != null) {
            return this.newRepository;
        }
        String uid = this.gpUtil.getSettingsManager().getGlobalSettings().getSiteTitle() + "-" + this.getProjectName() + "-F" + this.fileRepositories.size();
        this.newRepository = Repository.newInstance((String)uid);
        return this.newRepository;
    }

    private boolean pathAlreadyExists() throws GreenPepperServerException {
        if (this.fileRepositories == null) {
            this.setFileRepositories(this.getService().getAllSpecificationRepositories());
        }
        for (Repository repo : this.fileRepositories) {
            if (!repo.getBaseTestUrl().equals(this.newBaseTestUrl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public LinkedList<Project> getProjects() {
        if (this.projects != null) {
            return this.projects;
        }
        try {
            this.projects = new LinkedList(this.getService().getAllProjects());
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return this.projects;
    }
}

