/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.actions.server;

import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.greenpepper.confluence.GreenPepperServerConfigurationActivator;
import com.greenpepper.confluence.actions.server.GreenPepperServerAction;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.database.SupportedDialects;
import com.greenpepper.util.I18nUtil;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class InstallationAction
extends GreenPepperServerAction {
    private static final Logger log = Logger.getLogger(InstallationAction.class);
    private static final String RESOURCE_BUNDLE = InstallationAction.class.getName();
    private final ThreadLocal<Locale> threadLocale = new ThreadLocal();
    private ResourceBundle resourceBundle;
    private String installType;
    private String jndiUrl;
    private String hibernateDialect;
    private boolean editMode;

    public String getActionName(String fullClassName) {
        return this.getText("greenpepper.install.title");
    }

    public String config() {
        return "success";
    }

    public List<SupportedDialects> getDialects() {
        return Arrays.asList(SupportedDialects.values());
    }

    public Boolean getEditMode() {
        return this.editMode | !this.isServerReady();
    }

    public void setEditMode(Boolean editMode) {
        this.editMode = editMode;
    }

    public boolean getIsCustomSetup() {
        return this.isCustomSetup();
    }

    public boolean isCustomSetup() {
        return this.getInstallType().equals("customInstall");
    }

    public String getInstallType() {
        return this.installType == null ? (this.getJndiUrl() == null ? "quickInstall" : "customInstall") : this.installType;
    }

    public void setInstallType(String installType) {
        this.installType = installType;
    }

    public String changeInstallationType() {
        return "success";
    }

    public String getJndiUrl() {
        return this.jndiUrl == null ? this.getConfigurationActivator().getConfigJnriUrl() : this.jndiUrl;
    }

    public void setJndiUrl(String jndiUrl) {
        this.jndiUrl = jndiUrl;
    }

    public String getHibernateDialect() {
        return this.hibernateDialect == null ? this.getConfigurationActivator().getConfigDialect() : this.hibernateDialect;
    }

    public void setHibernateDialect(String hibernateDialect) {
        this.hibernateDialect = hibernateDialect;
    }

    @Override
    @HtmlSafe
    public String getText(String key) {
        String text = super.getText(key);
        if (text.equals(key)) {
            text = I18nUtil.getText((String)key, (ResourceBundle)this.getResourceBundle());
        }
        return text;
    }

    private ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            Locale locale = this.threadLocale.get();
            if (locale == null) {
                locale = this.getLocale();
                this.threadLocale.set(locale == null ? Locale.ENGLISH : locale);
            }
            this.resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale);
        }
        return this.resourceBundle;
    }

    public boolean isSetupComplete() {
        return this.gpUtil.isServerSetupComplete();
    }

    @Override
    public boolean isServerReady() {
        return this.gpUtil.isServerReady();
    }

    public String editDbmsConfiguration() {
        try {
            if (this.isCustomSetup()) {
                if (this.hibernateDialect != null && this.jndiUrl != null) {
                    if (this.canConnectToDbms()) {
                        this.getConfigurationActivator().initCustomInstallConfiguration(this.hibernateDialect, this.jndiUrl);
                    } else {
                        this.addActionError("greenpepper.install.dbms.test.failure");
                    }
                }
            } else {
                this.getConfigurationActivator().initQuickInstallConfiguration();
            }
        }
        catch (GreenPepperServerException ex) {
            this.addActionError("greenpepper.install.dbms.init.failure");
        }
        return "success";
    }

    public String testDbmsConnection() {
        if (!this.canConnectToDbms()) {
            this.addActionError("greenpepper.install.dbms.test.failure");
        }
        return "success";
    }

    private boolean canConnectToDbms() {
        try {
            InitialContext context = new InitialContext();
            DataSource ds = (DataSource)context.lookup(this.jndiUrl);
            Connection connection = ds.getConnection();
            connection.close();
            return true;
        }
        catch (Exception ex) {
            log.error((Object)("Testing Dbms Connection using jndi (" + this.jndiUrl + ")"), (Throwable)ex);
            return false;
        }
    }

    private GreenPepperServerConfigurationActivator getConfigurationActivator() {
        return this.gpUtil.getGPServerConfigurationActivator();
    }
}

