/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.macros;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.SpaceComparator;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.greenpepper.confluence.velocity.ConfluenceGreenPepper;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class AbstractGreenPepperMacro
extends BaseMacro {
    protected ConfluenceGreenPepper gpUtil = new ConfluenceGreenPepper();

    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    protected String getSpaceKey(Map parameters) throws GreenPepperServerException {
        String spaceKey = (String)parameters.get("spaceKey");
        if (spaceKey != null) {
            spaceKey = spaceKey.trim();
            Space space = this.gpUtil.getSpaceManager().getSpace(spaceKey);
            if (space == null) {
                throw new GreenPepperServerException("greenpepper.children.spacenotfound", spaceKey);
            }
            this.checkSpace(space);
        }
        return spaceKey;
    }

    protected String getSpaceKey(Map parameters, RenderContext renderContext, boolean checkPermission) throws GreenPepperServerException {
        Space space;
        String spaceKey = (String)parameters.get("spaceKey");
        if (spaceKey == null) {
            space = this.getCurrentSpace(renderContext);
        } else {
            spaceKey = spaceKey.trim();
            space = this.gpUtil.getSpaceManager().getSpace(spaceKey);
            if (space == null) {
                throw new GreenPepperServerException("greenpepper.children.spacenotfound", spaceKey);
            }
        }
        if (checkPermission) {
            this.checkSpace(space);
        }
        return space.getKey();
    }

    protected Space getCurrentSpace(RenderContext renderContext) {
        ContentEntityObject owner = ((PageContext)renderContext).getEntity();
        return ((Page)owner).getSpace();
    }

    protected String getPageTitle(Map parameters, RenderContext renderContext, String spaceKey) throws GreenPepperServerException {
        return this.getPage(parameters, renderContext, spaceKey).getTitle().trim();
    }

    protected Page getPage(Map parameters, RenderContext renderContext, String spaceKey) throws GreenPepperServerException {
        String pageTitle = (String)parameters.get("pageTitle");
        if (pageTitle == null) {
            ContentEntityObject owner = ((PageContext)renderContext).getEntity();
            return (Page)owner;
        }
        Page page = this.gpUtil.getPageManager().getPage(spaceKey, pageTitle);
        if (page == null) {
            throw new GreenPepperServerException("greenpepper.children.pagenotfound", String.format("'%s' in space '%s'", pageTitle, spaceKey));
        }
        return page;
    }

    protected List<Space> getSpaces() throws GreenPepperServerException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        List potentialSpaces = this.gpUtil.getSpaceManager().getAllSpaces();
        for (Space space : potentialSpaces) {
            try {
                if (!this.gpUtil.canView(space) || this.gpUtil.enable(space.getKey()) != null) continue;
                spaces.add(space);
            }
            catch (GreenPepperServerException e) {}
        }
        if (spaces.isEmpty()) {
            throw new GreenPepperServerException("greenpepper.labels.registeredspacesempty", "No registered repository");
        }
        Collections.sort(spaces, new SpaceComparator());
        return spaces;
    }

    protected String getBulkUID(Map parameters) {
        String group = (String)parameters.get("group");
        return StringUtil.isEmpty((String)group) ? "PAGE" : group;
    }

    protected boolean isExpanded(Map parameters) {
        String all = (String)parameters.get("expanded");
        return all != null && Boolean.valueOf(all) != false;
    }

    public static String getErrorView(String macroId, String errorId) {
        return AbstractGreenPepperMacro.getErrorView(macroId, errorId, null);
    }

    public static String getErrorView(String macroId, String errorId, String message) {
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("macroId", macroId);
        contextMap.put("errorId", errorId);
        contextMap.put("errorMessage", message != null ? message : "");
        return VelocityUtils.getRenderedTemplate((String)"/templates/greenpepper/confluence/macros/greenPepperMacros-error.vm", (Map)contextMap);
    }

    private void checkSpace(Space space) throws GreenPepperServerException {
        if (!this.gpUtil.canView(space)) {
            throw new GreenPepperServerException("greenpepper.macros.insufficientprivileges", "");
        }
        String msg = this.gpUtil.enable(space.getKey());
        if (msg != null) {
            throw new GreenPepperServerException("< " + space.getKey() + " > " + msg, "");
        }
    }
}

