/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.tools;

import com.greenpepper.util.URIUtil;
import com.greenpepper.util.cli.ArgumentMissingException;
import com.greenpepper.util.cli.CommandLine;
import com.greenpepper.util.cli.ParseException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.apache.xmlrpc.XmlRpcException;

public class ListRepo {
    public static final String URI = "http://localhost:8080";
    public static final String RPC_PATH = "/rpc/xmlrpc";
    private static final Vector EMPTY = new Vector(0);
    private CommandLine cli = new CommandLine();

    public void run(String ... args) throws Exception {
        this.defineCommandLine();
        if (!this.parseCommandLine(args)) {
            return;
        }
        this.listRepositories();
    }

    private boolean parseCommandLine(String[] args) throws ParseException {
        this.cli.parse(args);
        if (this.optionSpecified("help")) {
            return this.displayUsage();
        }
        if (this.optionSpecified("version")) {
            return this.displayVersion();
        }
        if (this.confluenceUrl() == null) {
            throw new ArgumentMissingException("confluence_url");
        }
        return true;
    }

    private String confluenceUrl() {
        return this.cli.getArgument(0) != null ? URIUtil.decoded((String)this.cli.getArgument(0)) : null;
    }

    private boolean optionSpecified(String name) {
        return this.cli.hasOptionValue(name);
    }

    private void listRepositories() {
        try {
            String xmlRpcUrl = this.getXmlRpcURL();
            System.out.println("Dumping repo list for : " + xmlRpcUrl);
            XmlRpcClientLite rpcClient = new XmlRpcClientLite(xmlRpcUrl);
            Vector repositories = (Vector)rpcClient.execute(ListRepo.buildRequest("getAllSpecificationRepositories"), EMPTY);
            System.out.println(repositories.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (XmlRpcException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getXmlRpcURL() {
        return this.confluenceUrl() + RPC_PATH;
    }

    private void defineCommandLine() {
        String banner = "com.greenpepper.confluence.tools.ListRepo [options] confluence_url\nList all the repositories found in the specified confluence ";
        this.cli.setBanner(banner);
        this.cli.defineOption(this.cli.buildOption("help", new String[]{"--help", "Display this help and exit"}));
        this.cli.defineOption(this.cli.buildOption("version", new String[]{"--version", "Output version information and exit"}));
    }

    private boolean displayVersion() {
        System.out.println(String.format("GreenPepper version \"%s\"", "4.0-beta2"));
        return false;
    }

    private boolean displayUsage() {
        System.out.println(this.cli.usage());
        return false;
    }

    private static String buildRequest(String methodName) {
        return "greenpepper1." + methodName;
    }

    public static void main(String[] args) {
        ListRepo listRepo = new ListRepo();
        try {
            listRepo.run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

