/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.utils.stylesheet;

import com.greenpepper.confluence.utils.ConfluenceVersion;
import com.greenpepper.confluence.utils.stylesheet.StyleSheetExtractor;
import com.greenpepper.util.ClassUtils;
import com.greenpepper.util.ExceptionImposter;

public class StyleSheetExtractorFactory {
    private static StyleSheetExtractor instance;

    public static StyleSheetExtractor getInstance() {
        if (instance == null) {
            instance = StyleSheetExtractorFactory.createStyleSheetExtractor(ConfluenceVersion.getCurrentVersion().compareTo(ConfluenceVersion.V28X) < 0 ? "OldStyleSheetExtractorImpl" : "DefaultStyleSheetExtractorImpl");
        }
        return instance;
    }

    private static StyleSheetExtractor createStyleSheetExtractor(String implementationClassName) {
        try {
            Class clazz = ClassUtils.loadClass((String)(StyleSheetExtractorFactory.class.getPackage().getName() + "." + implementationClassName));
            return (StyleSheetExtractor)clazz.newInstance();
        }
        catch (Exception e) {
            throw ExceptionImposter.imposterize((Throwable)e);
        }
    }
}

