/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence;

import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.greenpepper.server.GreenPepperServerException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class GreenPepperUserGroup {
    private static final Logger log = Logger.getLogger(GreenPepperUserGroup.class);
    private static final String GREENPEPPER_USERS = "greenpepper-users";
    private GroupManager groupManager;

    public void createIfNeeded() {
        Group group = null;
        try {
            group = this.getGreenPepperUserGroup();
        }
        catch (Exception ex) {
            log.warn((Object)"No 'greenpepper-users' group defined.  Will be created");
        }
        if (group == null) {
            try {
                this.getGroupManager().createGroup(GREENPEPPER_USERS);
            }
            catch (Exception ex) {
                log.warn((Object)"Creating 'greenpepper-users' group fail", (Throwable)ex);
            }
        }
    }

    public int getNumberOfUserForGroup() throws GreenPepperServerException {
        try {
            long start = System.currentTimeMillis();
            Iterator itr = this.getMembers().iterator();
            int count = 0;
            while (itr.hasNext()) {
                itr.next();
                ++count;
            }
            log.debug((Object)("Number of user (member of 'greenpepper-users') = " + count + " (" + (System.currentTimeMillis() - start) + " ms.)"));
            return count;
        }
        catch (Exception ex) {
            log.error((Object)"Getting user-count for group", (Throwable)ex);
            throw new RuntimeException("Getting user-count for group", ex);
        }
    }

    public boolean hasMembership(User user) {
        try {
            Group group = this.getGreenPepperUserGroup();
            return this.getGroupManager().hasMembership(group, user);
        }
        catch (Exception ex) {
            log.error((Object)("Verifying membership of  user '" + user.getName() + "'"), (Throwable)ex);
            return false;
        }
    }

    public boolean addMembership(User user) {
        try {
            Group group = this.getGreenPepperUserGroup();
            this.getGroupManager().addMembership(group, user);
            return true;
        }
        catch (Exception ex) {
            log.error((Object)("Adding membership of  user '" + user.getName() + "'"), (Throwable)ex);
            return false;
        }
    }

    private Pager getMembers() throws EntityException {
        Group group = this.getGreenPepperUserGroup();
        return this.getGroupManager().getMemberNames(group);
    }

    private Group getGreenPepperUserGroup() throws EntityException {
        return this.getGroupManager().getGroup(GREENPEPPER_USERS);
    }

    private GroupManager getGroupManager() {
        if (this.groupManager != null) {
            return this.groupManager;
        }
        this.groupManager = (GroupManager)ContainerManager.getComponent((String)"groupManager");
        return this.groupManager;
    }
}

