/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.actions.server;

import com.atlassian.user.User;
import com.greenpepper.confluence.actions.server.GreenPepperServerAction;
import com.greenpepper.confluence.utils.HtmlUtils;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.domain.ClasspathSet;
import com.greenpepper.server.domain.Project;
import com.greenpepper.server.domain.Repository;
import com.greenpepper.server.domain.RepositoryType;
import com.greenpepper.server.domain.Runner;
import com.greenpepper.server.domain.SystemUnderTest;
import com.greenpepper.server.domain.component.ContentType;
import com.greenpepper.server.license.GreenPepperLicenceException;
import com.greenpepper.util.StringUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.lang.StringEscapeUtils;

public class RegistrationAction
extends GreenPepperServerAction {
    private Boolean readonly = Boolean.FALSE;
    private List<Runner> runners;
    private LinkedList<Project> projects;
    private List<SystemUnderTest> systemUnderTests;
    private SystemUnderTest selectedSut;
    private String selectedSutName;
    private String repositoryName;
    private String newProjectName;
    private String username;
    private String pwd;
    private String baseUrl;
    private String newSutName = "";
    private String newFixtureFactory;
    private String newFixtureFactoryArgs;
    private String newRunnerName = "";
    private Boolean selected = Boolean.FALSE;
    private String newProjectDependencyDescriptor;
    private String sutClasspath;
    private String fixtureClasspath;
    private boolean licenseValid = true;
    private boolean addMode;
    private boolean editMode;
    private boolean editPropertiesMode;
    private boolean editClasspathsMode;
    private boolean editFixturesMode;

    public String doGetRegistration() {
        if (!this.isServerReady()) {
            this.addActionError("greenpepper.server.noconfiguration");
            this.readonly = true;
            this.editMode = false;
            this.addMode = false;
            return "success";
        }
        try {
            if (this.gpUtil.isCommercialLicense()) {
                User activeUser = this.getRemoteUser();
                if (activeUser == null) {
                    this.addActionError("greenpepper.anonymous.accessdenied");
                    this.readonly = true;
                    this.editMode = false;
                    this.addMode = false;
                    return "success";
                }
                if (!this.gpUtil.getGreenPepperUserGroup().hasMembership(activeUser)) {
                    this.addActionError("greenpepper.notmemberof.greenpepperusers.group");
                    this.readonly = true;
                    this.editMode = false;
                    this.addMode = false;
                    return "success";
                }
            }
            this.licenseValid = true;
            if (StringUtil.isEmpty((String)this.projectName)) {
                this.projectName = this.getRegisteredRepository().getProject().getName();
            }
            if (StringUtil.isEmpty((String)this.repositoryName)) {
                this.repositoryName = this.getRegisteredRepository().getName();
            }
            if (StringUtil.isEmpty((String)this.username)) {
                this.username = this.getRegisteredRepository().getUsername();
            }
            if (StringUtil.isEmpty((String)this.pwd)) {
                this.pwd = this.getRegisteredRepository().getPassword();
            }
            this.checkRepositoryBaseUrl();
            return this.doGetSystemUnderTests();
        }
        catch (GreenPepperLicenceException e) {
            this.addActionError(e.getId());
            this.licenseValid = false;
            this.readonly = true;
            this.editMode = false;
            this.addMode = false;
        }
        catch (GreenPepperServerException e) {
            if (this.editMode && StringUtil.isEmpty((String)this.projectName) && !this.isWithNewProject()) {
                this.projectName = ((Project)this.getProjects().iterator().next()).getName();
            }
            this.readonly = true;
        }
        return this.editMode ? this.doGetSystemUnderTests() : "success";
    }

    public String doRegister() {
        try {
            if (this.getUsername() != null) {
                this.gpUtil.verifyCredentials(this.getUsername(), this.getPwd());
            }
            String uid = this.gpUtil.getSettingsManager().getGlobalSettings().getSiteTitle() + "-" + this.getSpaceKey();
            this.registeredRepository = Repository.newInstance((String)uid);
            this.registeredRepository.setProject(this.getProjectForRegistration());
            this.registeredRepository.setType(RepositoryType.newInstance((String)"CONFLUENCE"));
            this.registeredRepository.setName(this.repositoryName);
            this.registeredRepository.setContentType(ContentType.TEST);
            this.registeredRepository.setBaseUrl(this.getBaseUrl());
            this.registeredRepository.setBaseRepositoryUrl(this.repositoryBaseUrl());
            this.registeredRepository.setBaseTestUrl(this.newTestUrl());
            this.registeredRepository.setUsername(this.getUsername());
            this.registeredRepository.setPassword(this.getPwd());
            this.registeredRepository.setMaxUsers(this.gpUtil.getNumberOfUserForGreenPepperUserGroup());
            this.getService().registerRepository(this.registeredRepository);
            this.projectName = this.isWithNewProject() ? this.newProjectName : this.projectName;
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
            this.editMode = true;
            this.readonly = true;
        }
        return this.doGetRegistration();
    }

    public String doUpdateRegistration() {
        try {
            if (this.getUsername() != null) {
                this.gpUtil.verifyCredentials(this.getUsername(), this.getPwd());
            }
            String uid = this.gpUtil.getSettingsManager().getGlobalSettings().getSiteTitle() + "-" + this.getSpaceKey();
            Repository newRepository = Repository.newInstance((String)uid);
            newRepository.setProject(this.getProjectForRegistration());
            newRepository.setType(RepositoryType.newInstance((String)"CONFLUENCE"));
            newRepository.setName(this.repositoryName);
            newRepository.setContentType(ContentType.TEST);
            newRepository.setBaseUrl(this.getBaseUrl());
            newRepository.setBaseRepositoryUrl(this.repositoryBaseUrl());
            newRepository.setBaseTestUrl(this.newTestUrl());
            newRepository.setUsername(this.getUsername());
            newRepository.setPassword(this.getPwd());
            newRepository.setMaxUsers(this.gpUtil.getNumberOfUserForGreenPepperUserGroup());
            this.getService().updateRepositoryRegistration(newRepository);
            this.projectName = this.isWithNewProject() ? this.newProjectName : this.projectName;
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
            this.editMode = true;
            this.readonly = true;
        }
        return this.doGetRegistration();
    }

    public String doGetSystemUnderTests() {
        try {
            this.runners = this.getService().getAllRunners();
            if (this.runners.isEmpty()) {
                throw new GreenPepperServerException("greenpepper.suts.norunners", "No runners.");
            }
            this.systemUnderTests = this.getService().getSystemUnderTestsOfProject(this.projectName);
            if (this.selectedSut == null) {
                for (SystemUnderTest sut : this.systemUnderTests) {
                    if (sut.getName().equals(this.selectedSutName)) {
                        this.selectedSut = sut;
                        return "success";
                    }
                    if (!sut.isDefault()) continue;
                    this.selectedSut = sut;
                }
                if (this.selectedSut != null) {
                    this.selectedSutName = this.selectedSut.getName();
                }
            }
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
            this.addMode = false;
        }
        return "success";
    }

    public String doAddSystemUnderTest() {
        try {
            this.selectedSut = SystemUnderTest.newInstance((String)this.newSutName);
            this.selectedSut.setProject(Project.newInstance((String)this.projectName));
            this.selectedSut.setFixtureFactory(this.newFixtureFactory);
            this.selectedSut.setFixtureFactoryArgs(this.newFixtureFactoryArgs);
            this.selectedSut.setIsDefault(this.selected.booleanValue());
            this.selectedSut.setRunner(Runner.newInstance((String)this.newRunnerName));
            this.selectedSut.setProjectDependencyDescriptor(this.newProjectDependencyDescriptor);
            this.getService().createSystemUnderTest(this.selectedSut, this.getHomeRepository());
            this.successfullAction();
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return this.doGetSystemUnderTests();
    }

    public String doUpdateSystemUnderTest() {
        try {
            SystemUnderTest newSut = SystemUnderTest.newInstance((String)this.selectedSutName);
            newSut.setProject(Project.newInstance((String)this.projectName));
            newSut = this.getService().getSystemUnderTest(newSut, this.getHomeRepository());
            newSut.setName(this.newSutName);
            newSut.setFixtureFactory(this.newFixtureFactory);
            newSut.setFixtureFactoryArgs(this.newFixtureFactoryArgs);
            newSut.setRunner(Runner.newInstance((String)this.newRunnerName));
            newSut.setProjectDependencyDescriptor(this.newProjectDependencyDescriptor);
            this.getService().updateSystemUnderTest(this.selectedSutName, newSut, this.getHomeRepository());
            this.successfullAction();
            return this.doGetSystemUnderTests();
        }
        catch (GreenPepperServerException e) {
            try {
                this.runners = this.getService().getAllRunners();
                if (this.runners.isEmpty()) {
                    throw new GreenPepperServerException("greenpepper.suts.norunners", "No runners.");
                }
                this.systemUnderTests = this.getService().getSystemUnderTestsOfProject(this.projectName);
                this.selectedSut = SystemUnderTest.newInstance((String)this.selectedSutName);
                this.selectedSut.setProject(Project.newInstance((String)this.projectName));
                this.selectedSut.setFixtureFactory(this.newFixtureFactory);
                this.selectedSut.setFixtureFactoryArgs(this.newFixtureFactoryArgs);
                this.selectedSut.setRunner(Runner.newInstance((String)this.newRunnerName));
                this.selectedSut.setProjectDependencyDescriptor(this.newProjectDependencyDescriptor);
            }
            catch (GreenPepperServerException e1) {
                this.addActionError(e.getId());
            }
            this.addActionError(e.getId());
            return "success";
        }
    }

    public String doRemoveSystemUnderTest() {
        try {
            this.selectedSut = SystemUnderTest.newInstance((String)this.selectedSutName);
            this.selectedSut.setProject(Project.newInstance((String)this.projectName));
            this.getService().removeSystemUnderTest(this.selectedSut, this.getHomeRepository());
            this.selectedSutName = null;
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        this.selectedSut = null;
        return this.doGetSystemUnderTests();
    }

    public String doEditClasspath() {
        try {
            SystemUnderTest selectedSut = SystemUnderTest.newInstance((String)this.selectedSutName);
            selectedSut.setProject(Project.newInstance((String)this.projectName));
            selectedSut = this.getService().getSystemUnderTest(selectedSut, this.getHomeRepository());
            selectedSut.setSutClasspaths((SortedSet)ClasspathSet.parse((String)this.sutClasspath));
            this.getService().updateSystemUnderTest(this.selectedSutName, selectedSut, this.getHomeRepository());
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return this.doGetSystemUnderTests();
    }

    public Set<String> getClasspaths() {
        return this.selectedSut.getSutClasspaths();
    }

    public String getClasspathsAsTextAreaContent() {
        return HtmlUtils.stringSetToTextArea(this.getClasspaths());
    }

    public String getClasspathTitle() {
        return this.getText("greenpepper.suts.classpath");
    }

    public String getFixtureClasspathTitle() {
        return this.getText("greenpepper.suts.fixture");
    }

    public Set<String> getFixtureClasspaths() {
        return this.selectedSut.getFixtureClasspaths();
    }

    public String getFixtureClasspathsAsTextAreaContent() {
        return HtmlUtils.stringSetToTextArea(this.getFixtureClasspaths());
    }

    public String doEditFixture() {
        try {
            SystemUnderTest selectedSut = SystemUnderTest.newInstance((String)this.selectedSutName);
            selectedSut.setProject(Project.newInstance((String)this.projectName));
            selectedSut = this.getService().getSystemUnderTest(selectedSut, this.getHomeRepository());
            selectedSut.setFixtureClasspaths((SortedSet)ClasspathSet.parse((String)this.fixtureClasspath));
            this.getService().updateSystemUnderTest(this.selectedSutName, selectedSut, this.getHomeRepository());
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return this.doGetSystemUnderTests();
    }

    public String doSetAsDefault() {
        try {
            SystemUnderTest sut = SystemUnderTest.newInstance((String)this.selectedSutName);
            sut.setProject(Project.newInstance((String)this.projectName));
            this.getService().setSystemUnderTestAsDefault(sut, this.getHomeRepository());
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return this.doGetSystemUnderTests();
    }

    @Override
    public LinkedList<Project> getProjects() {
        if (this.projects != null) {
            return this.projects;
        }
        try {
            this.projects = new LinkedList(this.getService().getAllProjects());
            this.projects.addLast(Project.newInstance((String)this.projectCreateOption()));
            this.projectName = this.projectName == null ? ((Project)this.projects.iterator().next()).getName() : this.projectName;
            return this.projects;
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
            return this.projects;
        }
    }

    public SystemUnderTest getSelectedSut() {
        return this.selectedSut;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName.trim();
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getPwd() {
        return this.pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = StringUtil.toNullIfEmpty((String)pwd.trim());
    }

    public String getEscapedPassword() {
        return StringEscapeUtils.escapeHtml((String)this.getPwd());
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = StringUtil.toNullIfEmpty((String)username.trim());
    }

    public String getNewProjectName() {
        return this.newProjectName;
    }

    public void setNewProjectName(String newProjectName) {
        this.newProjectName = newProjectName.trim();
    }

    public String getNewSutName() {
        return this.newSutName;
    }

    public void setNewSutName(String newSutName) {
        this.newSutName = newSutName.trim();
    }

    public String getNewFixtureFactory() {
        return this.newFixtureFactory;
    }

    public void setNewFixtureFactory(String fixtureFactory) {
        this.newFixtureFactory = StringUtil.toNullIfEmpty((String)fixtureFactory.trim());
    }

    public String getNewFixtureFactoryArgs() {
        return this.newFixtureFactoryArgs;
    }

    public void setNewFixtureFactoryArgs(String fixtureFactoryArgs) {
        this.newFixtureFactoryArgs = StringUtil.toNullIfEmpty((String)fixtureFactoryArgs.trim());
    }

    public String getNewRunnerName() {
        return this.newRunnerName;
    }

    public void setNewRunnerName(String runnerName) {
        this.newRunnerName = runnerName.trim();
    }

    public String getSutClasspath() {
        return this.sutClasspath;
    }

    public void setSutClasspath(String sutClasspath) {
        this.sutClasspath = sutClasspath.trim();
    }

    public String getFixtureClasspath() {
        return this.fixtureClasspath;
    }

    public void setFixtureClasspath(String fixtureClasspath) {
        this.fixtureClasspath = fixtureClasspath.trim();
    }

    public String getNewProjectDependencyDescriptor() {
        return this.newProjectDependencyDescriptor;
    }

    public void setNewProjectDependencyDescriptor(String newProjectDependencyDescriptor) {
        this.newProjectDependencyDescriptor = StringUtil.toNullIfEmpty((String)newProjectDependencyDescriptor.trim());
    }

    public Boolean getDefault() {
        return this.selected;
    }

    public void setDefault(Boolean selected) {
        this.selected = selected;
    }

    public List<Runner> getRunners() {
        return this.runners;
    }

    public String getSelectedSutName() {
        return this.selectedSutName;
    }

    public void setSelectedSutName(String selectedSutName) {
        this.selectedSutName = selectedSutName;
    }

    public boolean isLicenseValid() {
        return this.licenseValid;
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public boolean isAddMode() {
        return this.addMode;
    }

    public void setAddMode(boolean addMode) {
        this.addMode = addMode;
    }

    public boolean isEditClasspathsMode() {
        return this.editClasspathsMode;
    }

    public void setEditClasspathsMode(boolean editClasspathsMode) {
        this.editClasspathsMode = editClasspathsMode;
    }

    public boolean isEditFixturesMode() {
        return this.editFixturesMode;
    }

    public void setEditFixturesMode(boolean editFixturesMode) {
        this.editFixturesMode = editFixturesMode;
    }

    public boolean isEditPropertiesMode() {
        return this.editPropertiesMode;
    }

    public void setEditPropertiesMode(boolean editPropertiesMode) {
        this.editPropertiesMode = editPropertiesMode;
    }

    @Override
    public List<SystemUnderTest> getSystemUnderTests() {
        return this.systemUnderTests;
    }

    private Project getProjectForRegistration() throws GreenPepperServerException {
        if (this.isWithNewProject()) {
            this.validateProjectName();
            return Project.newInstance((String)this.newProjectName);
        }
        return Project.newInstance((String)this.projectName);
    }

    private void validateProjectName() throws GreenPepperServerException {
        if (StringUtil.isBlank((String)this.newProjectName) || this.newProjectName.equals(this.getText("greenpepper.project.newname"))) {
            throw new GreenPepperServerException("greenpepper.registration.invalidprojectname", "invalid name");
        }
    }

    private void successfullAction() {
        this.addMode = false;
        this.editPropertiesMode = false;
        this.editClasspathsMode = false;
        this.editFixturesMode = false;
        this.selectedSutName = this.newSutName;
        this.newSutName = "";
        this.newRunnerName = "";
        this.newFixtureFactory = null;
        this.newFixtureFactoryArgs = null;
        this.newProjectDependencyDescriptor = null;
    }

    private String getBaseUrl() {
        if (this.baseUrl != null) {
            return this.baseUrl;
        }
        this.baseUrl = this.gpUtil.getBaseUrl();
        return this.baseUrl;
    }

    private String repositoryBaseUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseUrl()).append("/display/").append(this.getSpaceKey());
        return sb.toString();
    }

    private String newTestUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseUrl()).append("/rpc/xmlrpc");
        sb.append("?handler=").append(this.getHandler());
        sb.append("#").append(this.getSpaceKey());
        return sb.toString();
    }

    private void checkRepositoryBaseUrl() throws GreenPepperServerException {
        if (!(this.editMode || this.addMode || this.getRegisteredRepository().getBaseUrl().equals(this.getBaseUrl()))) {
            this.addActionError(this.getText("greenpepper.server.repourloutofsync", new String[]{this.getRegisteredRepository().getBaseUrl(), this.getBaseUrl()}));
        }
    }
}

