/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.macros;

import com.atlassian.confluence.util.http.HttpResponse;
import com.atlassian.confluence.util.http.HttpRetrievalService;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.macro.MacroException;
import com.greenpepper.confluence.macros.AbstractGreenPepperMacro;
import com.greenpepper.confluence.macros.AbstractHttpRetrievalMacro;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.domain.Repository;
import com.greenpepper.util.StringUtil;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.Map;

public class GreenPepperManage
extends AbstractHttpRetrievalMacro {
    private HttpRetrievalService httpRetrievalService;

    public void setHttpRetrievalService(HttpRetrievalService httpRetrievalService) {
        this.httpRetrievalService = httpRetrievalService;
    }

    public String execute(Map parameters, String body, RenderContext context) throws MacroException {
        try {
            this.validateParams(parameters);
            String gpUrl = this.getParameter(parameters, "gpUrl");
            String gpService = this.getParameter(parameters, "gpService");
            String jiraUid = this.getParameter(parameters, "jiraUid");
            Repository repo = this.getRepository(gpUrl, gpService, jiraUid);
            String os_username = this.getParameter(parameters, "user");
            String os_password = this.getParameter(parameters, "pwd");
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(repo.getBaseRepositoryUrl()).append("/secure/VersionBulkManage.jspa?decorator=none&repositoryUid=").append(repo.getUid()).append("&versionName=").append(this.getParameter(parameters, "versionName"));
            if (os_username != null && os_password != null) {
                urlBuilder.append("&os_username=").append(os_username).append("&os_password=").append(os_password);
            }
            parameters.put("url", urlBuilder.toString());
            return this.execute2(parameters, body, context);
        }
        catch (GreenPepperServerException e) {
            return AbstractGreenPepperMacro.getErrorView("greenpepper.manage.macroid", e.getId());
        }
    }

    public String execute2(Map parameters, String body, RenderContext renderContext) throws MacroException {
        String url = this.cleanupUrl(RenderUtils.getParameter((Map)parameters, (String)"url", (int)0));
        if (!TextUtils.stringSet((String)url)) {
            return RenderUtils.blockError((String)"Could not retrieve RSS feed: no URL", (String)"");
        }
        HttpResponse response = null;
        try {
            response = this.httpRetrievalService.get(url);
            if (response.isNotFound()) {
                String s = this.notFound(url);
                if (response != null) {
                    response.finish();
                }
                return s;
            }
            if (response.isNotPermitted()) {
                String s = this.notPermitted(url);
                if (response != null) {
                    response.finish();
                }
                return s;
            }
            if (response.isFailed()) {
                String s = this.failed(url, response);
                if (response != null) {
                    response.finish();
                }
                return s;
            }
            String s1 = this.successfulResponse(parameters, renderContext, url, response);
            if (response != null) {
                response.finish();
            }
            return s1;
        }
        catch (IOException e) {
            throw new MacroException("Unable to retrieve " + url + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String getName() {
        return "greenpepper-manage";
    }

    private void validateParams(Map parameters) throws GreenPepperServerException {
        if (StringUtil.isBlank((String)((String)parameters.get("gpUrl")))) {
            throw new GreenPepperServerException("greenpepper.manage.missingurl", "");
        }
        if (StringUtil.isBlank((String)((String)parameters.get("gpService")))) {
            throw new GreenPepperServerException("greenpepper.manage.missingservice", "");
        }
        if (StringUtil.isBlank((String)((String)parameters.get("versionName")))) {
            throw new GreenPepperServerException("greenpepper.manage.missingversion", "");
        }
        if (StringUtil.isBlank((String)((String)parameters.get("jiraUid")))) {
            throw new GreenPepperServerException("greenpepper.manage.missinguid", "");
        }
    }
}

