/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.macros.historic;

import com.atlassian.confluence.core.DateFormatter;
import com.greenpepper.confluence.macros.historic.AbstractChartBuilder;
import com.greenpepper.confluence.macros.historic.ChartLongValue;
import com.greenpepper.confluence.macros.historic.HistoricParameters;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.domain.Execution;
import com.greenpepper.util.StringUtil;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class LinearExecutionChartBuilder
extends AbstractChartBuilder {
    private final List<Execution> executions;

    private LinearExecutionChartBuilder(HistoricParameters settings, List<Execution> executions) {
        super(settings);
        this.executions = executions;
    }

    public static AbstractChartBuilder newInstance(HistoricParameters settings, List<Execution> executions) {
        return new LinearExecutionChartBuilder(settings, executions);
    }

    @Override
    public String generateChart() throws GreenPepperServerException {
        try {
            CategoryDataset dataset = this.generateDataset();
            JFreeChart chart = this.createChart(dataset);
            BufferedImage chartImage = this.createChartImage(chart);
            return this.getDownloadPath(chartImage);
        }
        catch (IOException e) {
            throw new GreenPepperServerException("greenpepper.server.generalexeerror", e.getMessage(), (Throwable)e);
        }
    }

    private CategoryDataset generateDataset() {
        DateFormatter dateFormatter = this.gpUtil.getUserPreferencesDateFormatter();
        String successLabel = this.gpUtil.getText("greenpepper.historic.success");
        String failuresLabel = this.gpUtil.getText("greenpepper.historic.failures");
        String ignoredLabel = this.gpUtil.getText("greenpepper.historic.ignored");
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int count = this.executions.size();
        for (Execution exec : this.executions) {
            String category = String.format("%2d. %s", count, dateFormatter.formatDateTime((Date)exec.getExecutionDate()));
            if (!StringUtil.isEmpty((String)exec.getSections())) {
                category = category + "*";
            }
            ChartLongValue value = new ChartLongValue(category, exec.getId());
            double failureCount = exec.getErrors() + exec.getFailures() + (exec.hasException() ? 1 : 0);
            dataset.addValue((Number)new Double(exec.getSuccess()), (Comparable)((Object)successLabel), (Comparable)value);
            if (this.settings.isShowIgnored()) {
                dataset.addValue((Number)new Double(exec.getIgnored()), (Comparable)((Object)ignoredLabel), (Comparable)value);
            }
            dataset.addValue((Number)new Double(failureCount), (Comparable)((Object)failuresLabel), (Comparable)value);
            --count;
        }
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset) throws IOException {
        JFreeChart chart = ChartFactory.createAreaChart((String)this.settings.getTitle(), null, (String)this.gpUtil.getText("greenpepper.historic.chart.x.title"), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        this.customizeChart(chart);
        return chart;
    }

    private void customizeChart(JFreeChart chart) throws IOException {
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBorderVisible(this.settings.isBorder());
        TextTitle chartTitle = chart.getTitle();
        this.customizeTitle(chartTitle, DEFAULT_TITLE_FONT);
        this.addSubTitle(chart, this.settings.getSubTitle(), DEFAULT_SUBTITLE_FONT);
        this.addSubTitle(chart, this.settings.getSubTitle2(), DEFAULT_SUBTITLE2_FONT);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setNoDataMessage(this.gpUtil.getText("greenpepper.historic.nodata"));
        CategoryItemRenderer renderer = plot.getRenderer();
        int index = 0;
        renderer.setSeriesPaint(index++, (Paint)GREEN_COLOR);
        if (this.settings.isShowIgnored()) {
            renderer.setSeriesPaint(index++, (Paint)Color.yellow);
        }
        renderer.setSeriesPaint(index, (Paint)Color.red);
        renderer.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        renderer.setItemURLGenerator(new CategoryURLGenerator(){

            public String generateURL(CategoryDataset data, int series, int category) {
                Comparable valueKey = data.getColumnKey(category);
                ChartLongValue value = (ChartLongValue)valueKey;
                return "javascript:" + LinearExecutionChartBuilder.this.settings.getExecutionUID() + "_showExecutionResult('" + value.getId() + "');";
            }
        });
        CategoryAxis domainAxis = plot.getDomainAxis();
        this.customizeAxis((Axis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
        ValueAxis rangeAxis = plot.getRangeAxis();
        this.customizeAxis((Axis)rangeAxis);
        rangeAxis.setLowerBound(0.0);
        if (rangeAxis instanceof NumberAxis) {
            ((NumberAxis)rangeAxis).setTickUnit(new NumberTickUnit(1.0));
        }
        plot.setForegroundAlpha(0.8f);
    }
}

