/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.rpc.xmlrpc;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.rpc.InvalidSessionException;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.HtmlEntityEscapeUtil;
import com.atlassian.renderer.RenderContext;
import com.atlassian.user.User;
import com.greenpepper.confluence.utils.stylesheet.StyleSheetExtractorFactory;
import com.greenpepper.confluence.velocity.ConfluenceGreenPepper;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.domain.DocumentNode;
import com.greenpepper.server.rpc.GreenPepperRpcHelper;
import com.greenpepper.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class ConfluenceXmlRpcGreenPepperServiceImpl
implements GreenPepperRpcHelper {
    public static final String SPACE_NOT_FOUND = "greenpepper.rpc.spacenotfound";
    public static final String PAGE_NOT_FOUND = "greenpepper.rpc.pagenotfound";
    public static final String INVALID_SESSION = "greenpepper.rpc.invalidsession";
    public static final String PERMISSION_DENIED = "greenpepper.rpc.permissiondenied";
    public static final String GENERAL_EXCEPTION = "greenpepper.server.generalexeerror";
    private final Logger log = Logger.getLogger(ConfluenceXmlRpcGreenPepperServiceImpl.class);
    private ConfluenceGreenPepper gpUtil = new ConfluenceGreenPepper();

    public String getRenderedSpecification(final String username, final String password, final Vector<?> args) {
        if (args.size() < 3) {
            return this.error("Parameters Missing, expecting:[SpaceKey, PageTitle, IncludeStyle] !");
        }
        final boolean implementedVersion = args.size() < 4 || (Boolean)args.get(3) != false;
        TransactionTemplate txTemplate = new TransactionTemplate(this.gpUtil.getPlatformTransactionManager());
        return (String)txTemplate.execute(new TransactionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object doInTransaction(TransactionStatus transactionStatus) {
                String string;
                Page page;
                String token;
                block7: {
                    token = null;
                    token = ConfluenceXmlRpcGreenPepperServiceImpl.this.login(username, password);
                    page = ConfluenceXmlRpcGreenPepperServiceImpl.this.gpUtil.getPageManager().getPage((String)args.get(0), (String)args.get(1));
                    if (page != null) break block7;
                    String string2 = ConfluenceXmlRpcGreenPepperServiceImpl.this.error(ConfluenceXmlRpcGreenPepperServiceImpl.PAGE_NOT_FOUND);
                    ConfluenceXmlRpcGreenPepperServiceImpl.this.logout(token);
                    return string2;
                }
                try {
                    ConfluenceXmlRpcGreenPepperServiceImpl.this.checkPermissions(page.getSpace(), token);
                    string = ConfluenceXmlRpcGreenPepperServiceImpl.this.getRenderedSpecification(page, implementedVersion, (Boolean)args.get(2));
                }
                catch (NotPermittedException e) {
                    String string3 = ConfluenceXmlRpcGreenPepperServiceImpl.this.error(ConfluenceXmlRpcGreenPepperServiceImpl.PERMISSION_DENIED);
                    ConfluenceXmlRpcGreenPepperServiceImpl.this.logout(token);
                    return string3;
                }
                catch (RemoteException e2) {
                    String string4 = ConfluenceXmlRpcGreenPepperServiceImpl.this.error(ConfluenceXmlRpcGreenPepperServiceImpl.INVALID_SESSION);
                    {
                        catch (Throwable throwable) {
                            ConfluenceXmlRpcGreenPepperServiceImpl.this.logout(token);
                            throw throwable;
                        }
                    }
                    ConfluenceXmlRpcGreenPepperServiceImpl.this.logout(token);
                    return string4;
                }
                ConfluenceXmlRpcGreenPepperServiceImpl.this.logout(token);
                return string;
            }
        });
    }

    public Vector<?> getSpecificationHierarchy(final String username, final String password, final Vector<?> args) {
        if (args.isEmpty()) {
            return new DocumentNode("Parameters Missing, expecting:[SpaceKey] !").marshallize();
        }
        TransactionTemplate txTemplate = new TransactionTemplate(this.gpUtil.getPlatformTransactionManager());
        return (Vector)txTemplate.execute(new TransactionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object doInTransaction(TransactionStatus transactionStatus) {
                Vector vector;
                Space space;
                String token;
                block7: {
                    token = null;
                    token = ConfluenceXmlRpcGreenPepperServiceImpl.this.login(username, password);
                    space = ConfluenceXmlRpcGreenPepperServiceImpl.this.gpUtil.getSpaceManager().getSpace((String)args.get(0));
                    if (space != null) break block7;
                    Vector vector2 = new DocumentNode(ConfluenceXmlRpcGreenPepperServiceImpl.this.gpUtil.getText(ConfluenceXmlRpcGreenPepperServiceImpl.SPACE_NOT_FOUND)).marshallize();
                    ConfluenceXmlRpcGreenPepperServiceImpl.this.logout(token);
                    return vector2;
                }
                try {
                    ConfluenceXmlRpcGreenPepperServiceImpl.this.checkPermissions(space, token);
                    vector = ConfluenceXmlRpcGreenPepperServiceImpl.this.getSpecificationHierarchy(space);
                }
                catch (NotPermittedException e) {
                    Vector vector3 = new DocumentNode(ConfluenceXmlRpcGreenPepperServiceImpl.this.gpUtil.getText(ConfluenceXmlRpcGreenPepperServiceImpl.PERMISSION_DENIED)).marshallize();
                    ConfluenceXmlRpcGreenPepperServiceImpl.this.logout(token);
                    return vector3;
                }
                catch (RemoteException e2) {
                    Vector vector4 = new DocumentNode(ConfluenceXmlRpcGreenPepperServiceImpl.this.gpUtil.getText(ConfluenceXmlRpcGreenPepperServiceImpl.INVALID_SESSION)).marshallize();
                    {
                        catch (Throwable throwable) {
                            ConfluenceXmlRpcGreenPepperServiceImpl.this.logout(token);
                            throw throwable;
                        }
                    }
                    ConfluenceXmlRpcGreenPepperServiceImpl.this.logout(token);
                    return vector4;
                }
                ConfluenceXmlRpcGreenPepperServiceImpl.this.logout(token);
                return vector;
            }
        });
    }

    public String setSpecificationAsImplemented(final String username, final String password, final Vector<?> args) {
        if (args.size() < 3) {
            return this.error("Parameters Missing, expecting:[SpaceKey, PageTitle] !");
        }
        TransactionTemplate txTemplate = new TransactionTemplate(this.gpUtil.getPlatformTransactionManager());
        return (String)txTemplate.execute(new TransactionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object doInTransaction(TransactionStatus transactionStatus) {
                String string;
                Page page;
                String token;
                block7: {
                    token = null;
                    token = ConfluenceXmlRpcGreenPepperServiceImpl.this.login(username, password);
                    page = ConfluenceXmlRpcGreenPepperServiceImpl.this.gpUtil.getPageManager().getPage((String)args.get(0), (String)args.get(1));
                    if (page != null) break block7;
                    String string2 = ConfluenceXmlRpcGreenPepperServiceImpl.this.error(ConfluenceXmlRpcGreenPepperServiceImpl.PAGE_NOT_FOUND);
                    ConfluenceXmlRpcGreenPepperServiceImpl.this.logout(token);
                    return string2;
                }
                try {
                    ConfluenceXmlRpcGreenPepperServiceImpl.this.checkPermissions(page.getSpace(), token);
                    ConfluenceXmlRpcGreenPepperServiceImpl.this.gpUtil.saveImplementedVersion(page, page.getVersion());
                    string = "<success>";
                }
                catch (NotPermittedException e) {
                    String string3 = ConfluenceXmlRpcGreenPepperServiceImpl.this.error(ConfluenceXmlRpcGreenPepperServiceImpl.PERMISSION_DENIED);
                    ConfluenceXmlRpcGreenPepperServiceImpl.this.logout(token);
                    return string3;
                }
                catch (RemoteException e2) {
                    String string4 = ConfluenceXmlRpcGreenPepperServiceImpl.this.error(ConfluenceXmlRpcGreenPepperServiceImpl.INVALID_SESSION);
                    {
                        catch (Throwable throwable) {
                            ConfluenceXmlRpcGreenPepperServiceImpl.this.logout(token);
                            throw throwable;
                        }
                    }
                    ConfluenceXmlRpcGreenPepperServiceImpl.this.logout(token);
                    return string4;
                }
                ConfluenceXmlRpcGreenPepperServiceImpl.this.logout(token);
                return string;
            }
        });
    }

    public String saveExecutionResult(final String username, final String password, final Vector<?> args) {
        if (args.size() < 4) {
            return this.error("Parameters Missing, expecting:[SpaceKey, PageTitle, SUT, Xml Report Data] !");
        }
        TransactionTemplate txTemplate = new TransactionTemplate(this.gpUtil.getPlatformTransactionManager());
        return (String)txTemplate.execute(new TransactionCallback(){

            /*
             * Exception decompiling
             */
            public Object doInTransaction(TransactionStatus transactionStatus) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    private void checkPermissions(Space space, String token) throws InvalidSessionException, NotPermittedException {
        User user = this.getUser(token);
        ArrayList<String> permTypes = new ArrayList<String>();
        permTypes.add("VIEWSPACE");
        if (!this.gpUtil.getSpacePermissionManager().hasPermissionForSpace(user, permTypes, space)) {
            throw new NotPermittedException();
        }
    }

    private User getUser(String token) throws InvalidSessionException, NotPermittedException {
        if (StringUtil.isEmpty((String)token)) {
            return this.gpUtil.getTokenAuthenticationManager().makeAnonymousUser();
        }
        return this.gpUtil.getTokenAuthenticationManager().makeNonAnonymousUserFromToken(token);
    }

    private String login(String username, String password) throws RemoteException {
        if (StringUtil.isEmpty((String)username)) {
            return "";
        }
        String token = this.gpUtil.getTokenAuthenticationManager().login(username, password);
        AuthenticatedUserThreadLocal.setUser((User)this.getUser(token));
        return token;
    }

    private void logout(String token) {
        try {
            if (StringUtil.isEmpty((String)token)) {
                this.gpUtil.getTokenAuthenticationManager().logout(token);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        AuthenticatedUserThreadLocal.setUser(null);
    }

    private String getRenderedSpecification(Page page, boolean implementedVersion, boolean includeStyle) {
        try {
            String content;
            String baseUrl = this.gpUtil.getBaseUrl();
            StringBuffer basicRenderedPage = new StringBuffer("<html>\n");
            basicRenderedPage.append("<head>\n<title>").append(page.getTitle()).append("</title>\n");
            basicRenderedPage.append("<meta http-equiv=\"content-type\" content=\"text/html;charset=").append(this.gpUtil.getEncoding()).append("\"/>\n");
            basicRenderedPage.append("<meta name=\"title\" content=\"").append(page.getTitle()).append("\"/>\n");
            basicRenderedPage.append("<meta name=\"external-link\" content=\"").append(baseUrl).append(page.getUrlPath()).append("\"/>\n");
            if (includeStyle) {
                basicRenderedPage.append("<style>\n");
                basicRenderedPage.append(StyleSheetExtractorFactory.getInstance().renderStyleSheet(page.getSpace()));
                basicRenderedPage.append("</style>\n");
            }
            basicRenderedPage.append("</head>\n<body>\n");
            if (includeStyle) {
                basicRenderedPage.append("<div id=\"Content\" style=\"text-align:left; padding: 5px;\">\n");
            }
            if ((content = this.gpUtil.getPageContent(page, implementedVersion)) == null) {
                throw new GreenPepperServerException();
            }
            content = content.replaceAll("greenpepper-manage", "greenpepper-manage-not-rendered");
            content = content.replaceAll("greenpepper-hierarchy", "greenpepper-hierarchy-not-rendered");
            content = content.replaceAll("greenpepper-children", "greenpepper-children-not-rendered");
            content = content.replaceAll("greenpepper-labels", "greenpepper-labels-not-rendered");
            content = content.replaceAll("greenpepper-group", "greenpepper-group-not-rendered");
            content = content.replaceAll("\\{pagetree", "{pagetree-not-rendered");
            basicRenderedPage.append(this.gpUtil.getViewRenderer().render(content, (ConversionContext)new DefaultConversionContext((RenderContext)page.toPageContext())));
            if (includeStyle) {
                basicRenderedPage.append("\n</div>");
            }
            basicRenderedPage.append("\n</body>\n</html>");
            HtmlEntityEscapeUtil.unEscapeHtmlEntities((StringBuffer)basicRenderedPage);
            return basicRenderedPage.toString();
        }
        catch (GreenPepperServerException e) {
            return e.getId().equals("greenpepper.page.neverimplemented") ? this.warning(e.getId()) : this.error(e.getId());
        }
    }

    private Vector<?> getSpecificationHierarchy(Space space) {
        DocumentNode hierarchy = new DocumentNode(space.getName());
        List pages = this.gpUtil.getPageManager().getPages(space, true);
        for (Page page : pages) {
            if (!page.isRootLevel()) continue;
            DocumentNode node = this.buildNodeHierarchy(page, this.gpUtil);
            hierarchy.addChildren(node);
        }
        return hierarchy.marshallize();
    }

    private DocumentNode buildNodeHierarchy(Page page, ConfluenceGreenPepper gpUtil) {
        DocumentNode node = new DocumentNode(page.getTitle());
        node.setCanBeImplemented(gpUtil.canBeImplemented(page));
        List children = page.getChildren();
        for (Page child : children) {
            node.addChildren(this.buildNodeHierarchy(child, gpUtil));
        }
        return node;
    }

    private String error(String errorId) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("  <table style=\"text-align:center; border:1px solid #cc0000; border-spacing:0px; background-color:#ffcccc; padding:0px; margin:5px; width:100%;\">");
        sb.append("    <tr style=\"display:none\"><td>Comment</td></tr>");
        sb.append("    <tr><td id=\"conf_actionError_Msg\" style=\"color:#cc0000; font-size:12px; font-family:Arial, sans-serif; text-align:center; font-weight:bold;\">").append(this.gpUtil.getText(errorId)).append("</td></tr>");
        sb.append("  </table>");
        sb.append("</html>");
        return sb.toString();
    }

    private String warning(String errorId) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("  <table style=\"text-align:center; border:1px solid #FFD700; border-spacing:0px; background-color:#FFFF66; padding:0px; margin:5px; width:100%;\">");
        sb.append("    <tr style=\"display:none\"><td>Comment</td></tr>");
        sb.append("    <tr><td id=\"conf_actionWarn_Msg\" style=\"font-size:12px; font-family:Arial, sans-serif; text-align:center; font-weight:bold;\">").append(this.gpUtil.getText(errorId)).append("</td></tr>");
        sb.append("  </table>");
        sb.append("</html>");
        return sb.toString();
    }

    static /* synthetic */ Logger access$700(ConfluenceXmlRpcGreenPepperServiceImpl x0) {
        return x0.log;
    }
}

