/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.utils;

import com.atlassian.confluence.util.GeneralUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ConfluenceVersion
implements Comparable {
    public static final ConfluenceVersion V26X = new ConfluenceVersion(2, 6);
    public static final ConfluenceVersion V28X = new ConfluenceVersion(2, 8);
    public static final ConfluenceVersion V29X = new ConfluenceVersion(2, 9);
    public static final ConfluenceVersion V210X = new ConfluenceVersion(2, 10);
    public static final ConfluenceVersion V30X = new ConfluenceVersion(3, 0);
    public static final ConfluenceVersion V40X = new ConfluenceVersion(4, 0);
    public static final ConfluenceVersion V50X = new ConfluenceVersion(5, 0);
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+).(\\d+)(.\\d+)?");
    private static ConfluenceVersion CURRENT;
    private final int major;
    private final int minor;

    private ConfluenceVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConfluenceVersion)) {
            return false;
        }
        ConfluenceVersion version = (ConfluenceVersion)obj;
        return version.getMajor() == this.getMajor() && version.getMinor() == this.getMinor();
    }

    public int compareTo(Object o) {
        ConfluenceVersion version = (ConfluenceVersion)o;
        if (this.getMajor() > version.getMajor()) {
            return 1;
        }
        if (this.getMajor() < version.getMajor()) {
            return -1;
        }
        return new Integer(this.getMinor()).compareTo(version.getMinor());
    }

    public static ConfluenceVersion getCurrentVersion() {
        if (CURRENT == null) {
            CURRENT = ConfluenceVersion.extractVersionFrom(GeneralUtil.getVersionNumber());
        }
        return CURRENT;
    }

    static ConfluenceVersion extractVersionFrom(String version) {
        Matcher m = VERSION_PATTERN.matcher(version);
        if (m.find()) {
            String major = m.group(1);
            String minor = m.group(2);
            return new ConfluenceVersion(Integer.parseInt(major), Integer.parseInt(minor));
        }
        throw new RuntimeException("Cannot detect major version number from '" + GeneralUtil.getVersionNumber() + "'");
    }
}

