/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.utils.stylesheet;

import com.atlassian.confluence.importexport.resource.ResourceAccessor;
import com.atlassian.confluence.plugin.webresource.ConfluenceWebResourceManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.spring.container.ContainerManager;
import com.greenpepper.confluence.utils.stylesheet.StyleSheetExtractor;
import com.greenpepper.confluence.velocity.ConfluenceGreenPepper;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStyleSheetExtractorImpl
implements StyleSheetExtractor {
    private static final Logger log = LoggerFactory.getLogger(StyleSheetExtractor.class);
    private ConfluenceGreenPepper gpUtil = new ConfluenceGreenPepper();
    private String tableCssContent;

    @Override
    public String renderStyleSheet(Space space) {
        StringBuilder css = new StringBuilder();
        css.append('\n');
        css.append(this.getTablesCssContent());
        css.append('\n');
        css.append(this.getCombinedCss(space));
        return css.toString();
    }

    private String getTablesCssContent() {
        if (this.tableCssContent == null) {
            InputStream tableCssStream = null;
            try {
                ResourceAccessor resourceAccessor = (ResourceAccessor)ContainerManager.getComponent((String)"resourceAccessor");
                tableCssStream = resourceAccessor.getResource("/includes/css/tables.css");
                this.tableCssContent = IOUtils.toString((InputStream)tableCssStream);
            }
            catch (Exception ex) {
                try {
                    log.error("Failed to get tables stylesheet. Omitting tables styles.", (Throwable)ex);
                    this.tableCssContent = "/* Failed to get tables stylesheet. Omitting tables styles. */";
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(tableCssStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)tableCssStream);
            }
            IOUtils.closeQuietly((InputStream)tableCssStream);
        }
        return this.tableCssContent;
    }

    private String getCombinedCss(Space space) {
        ThemeManager themeManager = (ThemeManager)ContainerManager.getComponent((String)"themeManager");
        String spaceKey = space == null ? "" : space.getKey();
        Theme activeTheme = themeManager.getGlobalTheme();
        if (StringUtils.isNotEmpty((String)spaceKey)) {
            activeTheme = themeManager.getSpaceTheme(spaceKey);
        }
        ConfluenceWebResourceManager webResourceManager = (ConfluenceWebResourceManager)ContainerManager.getComponent((String)"webResourceManager");
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("spaceKey", spaceKey);
        contextMap.put("globalPrefix", this.gpUtil.getBaseUrl() + webResourceManager.getGlobalCssResourcePrefix());
        contextMap.put("prefix", this.gpUtil.getBaseUrl() + webResourceManager.getSpaceCssPrefix(spaceKey));
        contextMap.put("theme", activeTheme);
        contextMap.put("forWysiwyg", Boolean.TRUE);
        contextMap.put("generalUtil", new GeneralUtil());
        return VelocityUtils.getRenderedTemplate((String)"styles/combined-css.vm", contextMap);
    }
}

